<?php

use idoit\Module\Pro\Model\CategoryFolders\Category;
use idoit\Module\Pro\Model\CategoryFolders\Folder;

/**
 * i-doit
 *
 * Popup class for category folders feature.
 *
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_category_folders_delete extends isys_component_popup
{
    /**
     * Handles SMARTY request for dialog plus lists and builds the list base on the specified table.
     *
     * @param   isys_component_template & $p_tplclass
     * @param   array                   $p_params
     *
     * @return  string
     */
    public function handle_smarty_include(isys_component_template &$p_tplclass, $p_params)
    {
        // Will be accessed directly via JS.
        return '';
    }

    /**
     * Method for handling the module request.
     *
     * @param isys_module_request $p_modreq
     *
     * @throws \idoit\Exception\JsonException
     * @throws isys_exception_database
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        // Unpack popup request.
        $parameters = isys_format_json::decode(base64_decode($_POST['params']));

        $configurationId = (int)$parameters['configurationId'];
        $folderId = (int)$parameters['folderId'];

        $categoryModel = Category::instance($this->database);
        $folderModel = Folder::instance($this->database);
        $folderData = $folderModel->getById($folderId);

        if ($folderData['config'] != $configurationId) {
            // @todo Throw exception? What should happen?
        }

        // Check if the folder has children
        $hasChildrenFolders = count($folderModel->getAllByParent($folderId)) > 0;
        $hasChildrenCategory = count($categoryModel->getAllByFolder($folderId)) > 0;

        // Display the dialog template and return it.
        $this->template
            ->activate_editmode()
            ->assign('deleteFolderUrl', isys_application::instance()->container->get('route_generator')->generate('pro.category-folders.delete-folder'))
            ->assign('configurationId', $configurationId)
            ->assign('folderId', $folderId)
            ->assign('confirmationText', str_replace('{folder-name}', htmlentities($folderData['title']), $this->language->get('LC__CATEGORY_FOLDERS__DELETE_FOLDER_CONFIRMATION')));

        if ($hasChildrenFolders || $hasChildrenCategory) {
            $rules = [
                'C__CATEGORY_FOLDERS__FOLDER_LOCATION'         => [
                    'p_strPopupType'     => 'category_folders_selection',
                    'disableInputGroup'  => 'true',
                    'configId'           => $configurationId,
                    'preventSelectionOf' => $folderId
                ]
            ];

            $this->template
                ->activate_editmode()
                ->smarty_tom_add_rules('tom.popup.category-folders.delete-folder', $rules)
                ->display(dirname(__DIR__) . '/templates/SettingPage/CategoryFolders/popup/delete-folder-with-children.tpl');
        } else {
            $this->template->display(dirname(__DIR__) . '/templates/SettingPage/CategoryFolders/popup/delete-folder-without-children.tpl');
        }

        die;
    }
}
