[{isys_group name="tom.popup.category-folders.delete-folder"}]
<div id="category-folders-popup_delete-folder">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__DELETE_FOLDER"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content p10">
        <p>[{$confirmationText}]</p>
    </div>

    <div class="popup-footer">
        <button type="button" class="btn delete-button">
            <img src="[{$dir_images}]axialis/industry-manufacturing/waste-bin.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_DELETE"}]</span>
        </button>
        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        "use strict";

        const $popup = $('category-folders-popup_delete-folder');
        const $deleteButton = $popup.down('.delete-button');

        $popup.on('click', '.popup-closer', function () {
            popup_close();
        });

        $deleteButton.on('click', function () {
            new Ajax.Request('[{$deleteFolderUrl}]', {
                method:     'post',
                parameters: {
                    configurationId: parseInt('[{$configurationId}]'),
                    folderId: parseInt('[{$folderId}]')
                },
                onComplete:  function (xhr) {
                    if (!is_json_response(xhr, true)) {
                        return;
                    }

                    const json = xhr.responseJSON;

                    if (!json.success) {
                        idoit.Notify.error(json.message, { sticky: true });
                        return;
                    }

                    // @see ID-9531 Reload the structure, when a folder was deleted successfully.
                    if ($('category-tree')) {
                        $('category-tree').fire('reload:structure')
                    }

                    idoit.Notify.success('[{isys type="lang" ident="LC__CATEGORY_FOLDERS__FOLDER_DELETED"}]');
                    popup_close();
                }
            });
        });
    })();
</script>
[{/isys_group}]
