<div id="category-folders-popup_reset-folder">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__RESET_HEADLINE"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content p10">
        <p>[{$confirmationMessage}]</p>
    </div>

    <div class="popup-footer">
        <button type="button" class="btn reset-button">
            <img src="[{$dir_images}]axialis/industry-manufacturing/waste-bin.svg" alt="" /><span>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__RESET"}]</span>
        </button>
        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        "use strict";

        const $popup = $('category-folders-popup_reset-folder');
        const $resetButton = $popup.down('.reset-button');

        $popup.on('click', '.popup-closer', function () {
            popup_close();
        });

        $resetButton.on('click', function () {
            new Ajax.Request('[{$resetUrl}]', {
                method:     'post',
                parameters: {
                    configurationId: parseInt('[{$configurationId}]'),
                },
                onComplete:  function (xhr) {
                    if (!is_json_response(xhr, true)) {
                        return;
                    }

                    const json = xhr.responseJSON;

                    if (!json.success) {
                        idoit.Notify.error(json.message, { sticky: true });
                        return;
                    }

                    if ($('category-tree')) {
                        $('category-tree').fire('reload:structure')
                    }

                    idoit.Notify.success('[{isys type="lang" ident="LC__CATEGORY_FOLDERS__RESET_NOTIFICATION"}]');
                    popup_close();
                }
            });
        });
    })();
</script>
