[{isys_group name="tom.popup.category-folders.select-folder"}]
<div id="category-folders-popup_select-folder">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__POPUP__SELECT_FOLDER__TITLE"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content p20">
        <p>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__POPUP__SELECT_FOLDER__DESCRIPTION"}]</p>

        <div class="mb15 display-flex align-items-center">
            <button type="button" class="btn btn-secondary mt10 mb15" data-function="toggle-all" data-action="expand">
                <img src="[{$dir_images}]axialis/user-interface/angle-right-small.svg" alt="" /><span>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__EXPAND_ALL"}]</span>
            </button>

            <div class="category-folders-search-container hide">
                <input type="text" class="input input-small" placeholder="[{isys type="lang" ident="LC__UNIVERSAL__SEARCH"}]" />
                <img src="[{$dir_images}]axialis/basic/zoom.svg" alt="" />
            </div>
        </div>

        <div class="category-folders-config">
            <!-- Will be filled by JS -->
        </div>
    </div>

    <div class="popup-footer">
        <button type="button" class="btn move-button">
            <img src="[{$dir_images}]axialis/documents-folders/folder-copy-2-grey.svg" alt="" /><span>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__POPUP__SELECT_FOLDER__MOVE"}]</span>
        </button>
        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        "use strict";

        const $popup = $('category-folders-popup_select-folder');
        const $moveButton = $popup.down('.move-button');
        const $treeContainer = $popup.down('.category-folders-config');
        const $toggleAllButton = $popup.down('[data-function="toggle-all"]');
        const $searchCategoryField = $popup.down('.category-folders-search-container');

        const $targetField = $('[{$targetField}]');
        const hiddenData = JSON.parse('[{$hiddenData|json_encode|escape:"javascript"}]')
        const root = JSON.parse('[{$rootData|json_encode|escape:"javascript"}]')

        preventAccidentalFormSubmit($popup);

        const tree = new CategoryFoldersTree($treeContainer, {
            $toggleAll: $toggleAllButton,
            $searchCategoryField: $searchCategoryField,
            selectable: true,
            selection: hiddenData.folderId,
            preventSelectionOf: hiddenData.preventSelectionOf
        });

        new Ajax.Request('[{$loadConfigUrl}]', {
            method:     'get',
            onComplete:  function (xhr) {
                if (!is_json_response(xhr, true)) {
                    return;
                }

                const json = xhr.responseJSON;

                if (!json.success) {
                    idoit.Notify.error(json.message, { sticky: true });
                    return;
                }

                tree.setData(json.data.categories);
                tree.render();
            }
        });

        $popup.on('click', '.popup-closer', function () {
            popup_close('popup_commentary');
        });

        $moveButton.on('click', function () {
            const selectedFolder = $popup.down('input:checked');

            if (!selectedFolder) {
                idoit.Notify.info('[{isys type="lang" ident="LC__CATEGORY_FOLDERS__POPUP__SELECT_FOLDER__SELECT_TARGET_FOLDER"}]');
                return;
            }

            if (!$targetField) {
                idoit.Notify.info('[{isys type="lang" ident="LC__CATEGORY_FOLDERS__POPUP__SELECT_FOLDER__TARGET_FIELD_MISSING"}]');
                return;
            }

            // Update selection.
            hiddenData.folderId = +selectedFolder.getValue();
            hiddenData.folderName = selectedFolder.next('span').textContent;
            hiddenData.isRoot = hiddenData.folderId === root.id;

            $targetField.setValue(JSON.stringify(hiddenData));
            $targetField.fire('value:updated');
            popup_close('popup_commentary');
        });
    })();
</script>
[{/isys_group}]
