<?php

/**
 * i-doit - class autoloader
 *
 * @package     i-doit
 * @subpackage  General
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Psr4AutoloaderClass;

// Include composer's autoloader
if (file_exists(BASE_DIR . 'vendor/autoload.php')) {
    include_once BASE_DIR . 'vendor/autoload.php';
} else {
    throw new Exception("Composers autoloader not found. Composer could not be initialized! Run 'composer install' in root directory! (https://getcomposer.org)");
}

include_once __DIR__ . '/autoload-psr4.inc.php';
include_once __DIR__ . '/classes/modules/manager/isys_module_manager_autoload.class.php';

try {
    // Register our PSR4 autoloader
    Psr4AutoloaderClass::factory()->register();

    // @see ID-9145 Initialize our autoloader for legacy classes.
    Autoloader::init(include_once(__DIR__ . '/classmap.php'));

    $updatesClassMap = dirname(__DIR__) . '/updates/classmap.php';

    if (file_exists($updatesClassMap)) {
        Autoloader::appendClassmap(include_once($updatesClassMap));
    }
} catch (\Exception $e) {
    // Do nothing.
}
