<?php

namespace idoit\Module\JDisc\Graphql\Query\Job;

use GraphQL\Query;
use idoit\Module\JDisc\Graphql\Query\GetDiscoveryLog;
use idoit\Module\JDisc\Graphql\ResponseInterface;
use idoit\Module\JDisc\Graphql\Schema\Model\DiscoveryStatusAreaEnum;

class GetJobLog extends GetDiscoveryLog implements ResponseInterface
{
    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        return (new Query('status'))
            ->setSelectionSet([
                (new Query('discovery'))
                    ->setSelectionSet([
                        (new Query('status'))
                            ->setArguments(['statusArea' => new DiscoveryStatusAreaEnum('DiscoveryJobs')])
                            ->setSelectionSet([
                                (new Query('deviceQueueStatus'))
                                    ->setSelectionSet([
                                        'lastAction',
                                        (new Query('devices'))
                                            ->setSelectionSet(['target', 'lastLog'])
                                    ])
                            ])
                    ])
            ]);
    }
}