<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type NetworkInterface
 * A network interface */
final class NetworkInterfaceType implements AutoGenerationInterface
{
    /**
     * The network interface's administrative status
     */
    public ?InterfaceStatusEnum $administrativeStatus = null;
    /**
     * The network interface's annotation (often configured manually by the admins).
     */
    public ?string $annotation = null;
    /**
     * The network interface's description.
     */
    public ?string $description = null;
    /**
     * The owning device
     */
    public ?DeviceType $device = null;
    /**
     * The DHCP configuration (if it exists).
     */
    public ?IP4DHCPConfigurationType $dhcpConfig = null;
    /**
     * A flag whether this network interface has DHCP enabled or not
     */
    public ?bool $dhcpEnabled = null;
    /**
     * The DNS suffix search order.
     * @var null|iterable|string[]
     */
    public ?iterable $dnsSearchSuffixes = null;
    /**
     * The list of DNS Server configs (ordered by the index of definition).
     * @var null|iterable
     */
    public ?iterable $dnsServers = null;
    /**
     * The DNS suffix configured for this network interface
     */
    public ?string $dnsSuffix = null;
    /**
     * The network interface's duplex mode
     */
    public ?DuplexModeEnum $duplexMode = null;
    /**
     * The network interface's extended description.
     */
    public ?string $extendedDescription = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The network interface's physical address (MAC or WWN).
     */
    public ?int $index = null;
    /**
     * The list of ip4 transports including their configuration (subnet mask, hostnames).
     * @var null|iterable
     */
    public ?iterable $ip4Transports = null;
    /**
     * The list of ip6 transports including their configuration (network prefix, hostnames).
     * @var null|iterable
     */
    public ?iterable $ip6Transports = null;
    /**
     * The network interface's MTU configuration.
     */
    public ?int $mtu = null;
    /**
     * The network interface's operational status
     */
    public ?InterfaceStatusEnum $operationalStatus = null;
    /**
     * The network interface's physical address (MAC or WWN).
     */
    public ?string $physicalAddress = null;
    /**
     * The network interface's port id.
     */
    public ?int $portId = null;
    /**
     * The network interface's speed in Bits per second.
     */
    public $speed = null;
    /**
     * The network interface's type
     */
    public ?InterfaceTypeEnum $type = null;
    /**
     * A flag that indicates whether this mac address should be used to identify devices. Note that not all mac addresses can be used. For instance VPN mac addresses are often the same on ALL VPN clients!
     */
    public ?bool $useForIdentification = null;
    /**
     * The list of configured vlans for this network interface
     * @var null|iterable
     */
    public ?iterable $vlans = null;
    /**
     * The list of network interfaces physically connected to this interface.
Note that there might be more than one interface in cases where you have non-managed
switches conneting devices
     * @var null|iterable
     */
    public ?iterable $connectedNetworkInterfaces = null;
    /**
     * The list of topology connections for this interface.
Note that there might be more than one interface in cases where you have non-managed
switches conneting devices
     * @var null|iterable
     */
    public ?iterable $topologyConnections = null;
}