<?php

namespace idoit\Module\License\Event\Subscriber\Admin;

use idoit\Module\License\Event\License\LegacyLicenseAddedEvent;
use idoit\Module\License\Event\License\LegacyLicenseRemovedEvent;
use idoit\Module\License\Event\License\LicenseAddedEvent;
use idoit\Module\License\LicenseService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class LicenseSubscriber implements EventSubscriberInterface
{
    /**
     * @var LicenseService
     */
    private $licenseService;

    /**
     * LicenseSubscriber constructor.
     */
    public function __construct(LicenseService $licenseService)
    {
        $this->licenseService = $licenseService;
    }

    /**
     * Returns an array of event names this subscriber wants to listen to.
     *
     * The array keys are event names and the value can be:
     *
     *  * The method name to call (priority defaults to 0)
     *  * An array composed of the method name to call and the priority
     *  * An array of arrays composed of the method names to call and respective
     *    priorities, or 0 if unset
     *
     * For instance:
     *
     *  * array('eventName' => 'methodName')
     *  * array('eventName' => array('methodName', $priority))
     *  * array('eventName' => array(array('methodName1', $priority), array('methodName2')))
     *
     * @return array The event names to listen to
     */
    public static function getSubscribedEvents()
    {
        return [
            LegacyLicenseAddedEvent::NAME => 'updateObjectDivisionOnLegacyLicenseAdd',
            LegacyLicenseRemovedEvent::NAME => 'updateObjectDivisionOnLegacyLicenseRemove',
            LicenseAddedEvent::NAME => 'updateObjectDivisionOnLicenseAdd'
        ];
    }

    public function updateObjectDivisionOnLegacyLicenseAdd(LegacyLicenseAddedEvent $event)
    {
        $this->licenseService->updateObjectDivision();
    }

    public function updateObjectDivisionOnLegacyLicenseRemove(LegacyLicenseRemovedEvent $event)
    {
        $this->licenseService->updateObjectDivision();
    }

    public function updateObjectDivisionOnLicenseAdd(LicenseAddedEvent $event)
    {
        $this->licenseService->updateObjectDivision();
    }
}
