<?php

use idoit\Module\Pro\Controller\CategoryFolders\Config;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    $routes->add('pro.category-folders.load-config', '/ajax/category-folders/load-config/{objectTypeId}')
        ->methods(['GET'])
        ->requirements(['objectTypeId' => '\d*'])
        ->controller([Config::class, 'loadByObjectType']);

    $routes->add('pro.category-folders.save-config', '/ajax/category-folders/save-config/{objectTypeId}')
        ->methods(['POST'])
        ->requirements(['objectTypeId' => '\d*'])
        ->controller([Config::class, 'saveForObjectType']);

    $routes->add('pro.category-folders.edit-folder', '/ajax/category-folders/edit-folder')
        ->methods(['POST'])
        ->controller([Config::class, 'editFolder']);

    $routes->add('pro.category-folders.delete-folder', '/ajax/category-folders/delete-folder')
        ->methods(['POST'])
        ->controller([Config::class, 'deleteFolder']);

    $routes->add('pro.category-folders.move-item', '/ajax/category-folders/move-item')
        ->methods(['POST'])
        ->controller([Config::class, 'moveItem']);

    $routes->add('pro.category-folders.reset', '/ajax/category-folders/reset')
        ->methods(['POST'])
        ->controller([Config::class, 'reset']);
};
