[{isys_group name="tom.popup.category-folders.delete-folder"}]
<div id="category-folders-popup_delete-folder">
    <div class="modal-header">
        <h1>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__DELETE_FOLDER"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="modal-content p10">
        <p><strong>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__DELETE_FOLDER_WITH_CHILDREN_HEADLINE"}]</strong></p>
        <p class="mt10 mb20">[{isys type="lang" ident="LC__CATEGORY_FOLDERS__DELETE_FOLDER_WITH_CHILDREN_EXPLANATION"}]</p>
        <p class="mt20 mb20"><strong>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__DELETE_FOLDER_WITH_CHILDREN_DECISION"}]</strong></p>
        [{isys name="C__CATEGORY_FOLDERS__FOLDER_LOCATION" type="f_popup"}]
    </div>

    <div class="modal-footer">
        <button type="button" class="btn delete-button mr5">
            <img src="[{$dir_images}]axialis/industry-manufacturing/waste-bin.svg" alt="" /><span>[{isys type="lang" ident="LC__CATEGORY_FOLDERS__DELETE_AND_MOVE"}]</span>
        </button>
        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        "use strict";

        const $popup = $('category-folders-popup_delete-folder');
        const $deleteButton = $popup.down('.delete-button');

        preventAccidentalFormSubmit($popup);

        $popup.on('click', '.popup-closer', function () {
            Modal.close($popup.up('.modal'));
        });

        const $folderLocationField = $('C__CATEGORY_FOLDERS__FOLDER_LOCATION_FIELD');
        const $folderLocationRootCheckbox = $('C__CATEGORY_FOLDERS__FOLDER_LOCATION_ROOT_CHECKBOX');
        const $folderLocationHidden = $('C__CATEGORY_FOLDERS__FOLDER_LOCATION_HIDDEN');

        $folderLocationHidden.on('value:updated', function () {
            const parent = JSON.parse($folderLocationHidden.getValue());

            $folderLocationField.setValue(parent.folderName);

            // Remove the 'folderName' because it might contain UTF8 characters that will cause errors when sent to the backend.
            delete parent.folderName;

            $folderLocationHidden.setValue(JSON.stringify(parent));

            if (parent.isRoot) {
                $folderLocationRootCheckbox.setValue(1);
                $folderLocationRootCheckbox.disable();
            } else {
                $folderLocationRootCheckbox.enable();
                $folderLocationRootCheckbox.setValue(0);
            }
        });

        $deleteButton.on('click', function () {
            const hiddenData = JSON.parse($folderLocationHidden.getValue());

            new Ajax.Request('[{$deleteFolderUrl}]', {
                method:     'post',
                parameters: {
                    configurationId: parseInt('[{$configurationId}]'),
                    folderId: parseInt('[{$folderId}]'),
                    newParentId: hiddenData.folderId
                },
                onComplete:  function (xhr) {
                    if (!is_json_response(xhr, true)) {
                        return;
                    }

                    const json = xhr.responseJSON;

                    if (!json.success) {
                        idoit.Notify.error(json.message, { sticky: true });
                        return;
                    }

                    // @see ID-9531 Reload the structure, when a folder was deleted successfully.
                    if ($('category-tree')) {
                        $('category-tree').fire('reload:structure')
                    }

                    idoit.Notify.success('[{isys type="lang" ident="LC__CATEGORY_FOLDERS__FOLDER_DELETED"}]');
                    Modal.close($popup.up('.modal'));
                }
            });
        });
    })();
</script>
[{/isys_group}]
