<?php

use idoit\Module\System\Controller\AddOnController;
use idoit\Module\System\Controller\DownloadController;
use idoit\Module\System\Controller\UpdateCheckController;
use idoit\Module\System\Controller\UploadController;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    $routes->add('add-ons.load', '/ajax/load-addons')
        ->methods(['GET'])
        ->controller([AddOnController::class, 'getForMenu']);

    $routes->add('system.ajax-upload', '/ajax/upload/{type}')
        ->methods(['POST'])
        ->requirements(['type' => '[a-z0-9\._-]+'])
        ->controller([UploadController::class, 'process']);

    $routes->add('system.file-download', '/download/{type}/{identifier}')
        ->methods(['GET'])
        ->requirements(['type' => '[a-z0-9\._-]+', 'identifier' => '[a-z0-9\._-]*'])
        ->controller([DownloadController::class, 'process']);

    $routes->add('system.update-check', '/ajax/update-check')
        ->methods(['GET'])
        ->controller([UpdateCheckController::class, 'check']);
};
