<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Psr4AutoloaderClass;

// Process autoloaders.
Autoloader::appendClassmap(require __DIR__ . '/classmap.php');
Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\CustomFields', __DIR__ . '/src/');

// Register routes.
isys_request_controller::instance()
    ->addModuleRoute('POST', '/custom_fields/ajax/find-property-by-key', 'custom_fields', 'Ajax', 'findPropertyByKey');

isys_application::instance()->container->get('signals')
    ->connect('mod.cmdb.customCategoryPropertyKeyChanged', ['isys_module_custom_fields', 'propertyKeyChanged']);
