<?php

namespace idoit\Module\Pro\Algorithm;

/**
 * Algorithm filter class.
 *
 * @package idoit\Module\Pro\Algorithm
 */
class Filter
{
    /**
     * @var array
     */
    private $cmdbStatus = [];

    /**
     * @var int
     */
    private $priority = 0;

    /**
     * @var int
     */
    private $level = 1;

    /**
     * @var array
     */
    private $relationTypes = [];

    /**
     * @var array
     */
    private $objectTypes = [];

    /**
     * @param array $cmdbStatus
     *
     * @return $this
     */
    public function setCmdbStatus(array $cmdbStatus): self
    {
        $this->cmdbStatus = $cmdbStatus;

        return $this;
    }

    /**
     * @return array
     */
    public function getCmdbStatus(): array
    {
        return $this->cmdbStatus;
    }

    /**
     * @param int $priority
     *
     * @return $this
     */
    public function setPriority(int $priority): self
    {
        $this->priority = $priority;

        return $this;
    }

    /**
     * @return int
     */
    public function getPriority(): int
    {
        return $this->priority;
    }

    /**
     * @param int $level
     *
     * @return $this
     */
    public function setLevel(int $level): self
    {
        $this->level = $level;

        return $this;
    }

    /**
     * @return int
     */
    public function getLevel(): int
    {
        return $this->level;
    }

    /**
     * @param array $relationTypes
     *
     * @return $this
     */
    public function setRelationTypes(array $relationTypes): self
    {
        $this->relationTypes = $relationTypes;

        return $this;
    }

    /**
     * @return array
     */
    public function getRelationTypes(): array
    {
        return $this->relationTypes;
    }

    /**
     * @param array $objectTypes
     *
     * @return $this
     */
    public function setObjectTypes(array $objectTypes): self
    {
        $this->objectTypes = $objectTypes;

        return $this;
    }

    /**
     * @return array
     */
    public function getObjectTypes(): array
    {
        return $this->objectTypes;
    }
}
