<?php

/**
 * i-doit Report View for showing all network connections
 *
 * @package     i-doit
 * @subpackage  Reports
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_report_view_network_connections extends isys_report_view
{

    /**
     * @return string
     */
    public static function name()
    {
        return 'LC__CATG__NET_CONNECTIONS';
    }

    /**
     * @return string
     */
    public static function description()
    {
        return 'LC__REPORT__VIEW__DESCRIPTION__NETWORK_CONNECTIONS';
    }

    /**
     * @return string
     */
    public function template()
    {
        return isys_module_report::getPath() . 'templates/view_network_connections.tpl';
    }

    /**
     * @return string
     */
    public static function viewtype()
    {
        return 'LC__CMDB__OBJTYPE__CATG';
    }

    /**
     *
     */
    public function start()
    {
        $daoNetListener = isys_cmdb_dao_category_g_net_listener::instance($this->database);
        $l_rules['dialog_protocol']['p_arData'] = $daoNetListener->get_dialog_as_array('isys_net_protocol');
        $l_rules['dialog_protocol_5']['p_arData'] = $daoNetListener->get_dialog_as_array('isys_net_protocol_layer_5');

        $l_dao_net = new isys_cmdb_dao_category_s_net($this->database);
        $l_arNetworks = [];
        $l_networks = $l_dao_net->get_data();
        while ($row = $l_networks->get_row()) {
            $l_arNetworks[$row['isys_obj__id']] = $row['isys_obj__title'] . ' (' . $row['isys_cats_net_list__address'] . ')';
        }
        $l_rules['dialog_net']['p_arData'] = $l_arNetworks;

        $parameters = $_GET;
        $parameters[C__GET__AJAX] = 1;

        $this->template
            ->activate_editmode()
            ->assign('reportViewAjaxUrl', isys_helper_link::create_url($parameters))
            ->smarty_tom_add_rules('tom.content.bottom.content', $l_rules);
    }

    /**
     *
     */
    public function ajax_request()
    {
        $return = [];
        $condition = '';
        $daoNetListener = isys_cmdb_dao_category_g_net_listener::instance($this->database);

        if (isset($_POST['dialog_protocol']) && $_POST['dialog_protocol'] > 0) {
            $condition .= ' AND isys_net_protocol__id = ' . $daoNetListener->convert_sql_id($_POST['dialog_protocol']);
        }
        if (isset($_POST['dialog_protocol_5']) && $_POST['dialog_protocol_5'] > 0) {
            $condition .= ' AND isys_net_protocol_layer_5__id = ' . $daoNetListener->convert_sql_id($_POST['dialog_protocol_5']);
        }

        if (isset($_POST['text_port']) && $_POST['text_port'] > 0) {
            $condition .= ' AND isys_catg_net_listener_list__port_from >= ' . $daoNetListener->convert_sql_id($_POST['text_port']) .
                ' AND isys_catg_net_listener_list__port_to <= ' . $daoNetListener->convert_sql_id($_POST['text_port']);
        }

        if (isset($_POST['dialog_net']) && $_POST['dialog_net'] > 0) {
            $condition .= ' AND network.isys_obj__id = ' . $daoNetListener->convert_sql_id($_POST['dialog_net']);
        }

        $l_connections = $daoNetListener->get_connections($condition);

        $return[] = [
            $this->language->get('LC__CMDB__OBJTYPE__LAYER3_NET'),
            $this->language->get('LC__CMDB__CATG__NET_CONNECTOR__SOURCE_DEVICE'),
            $this->language->get('LC__CMDB__CATG__NET_CONNECTOR__IP_ADDRESS'),
            $this->language->get('LC__CATD__PROTOCOL') . '/Port',
            $this->language->get('LC__CMDB__CATG__NET_LISTENER__LISTENER_PORT'),
            $this->language->get('LC__CMDB__CATG__NET_LISTENER__BIND_DEVICE'),
            $this->language->get('LC__CMDB__CATG__NET_LISTENER__DESTINATION_IP_ADDRESS'),
            $this->language->get('LC__CMDB__CATG__APPLICATION_OBJ_APPLICATION'),
            $this->language->get('LC__CATG__NET_CONNECTIONS__GATEWAY') . '-Source',
            $this->language->get('LC__CATG__NET_CONNECTIONS__GATEWAY') . '-Destination',
        ];


        while ($row = $l_connections->get_row()) {
            $layer5 = '';
            $listenerPort = '';

            if (isset($row['protocol_layer_5']) && $row['protocol_layer_5']) {
                $layer5 = ': ' . $row['protocol_layer_5'];
            }

            $sourcePort = ($row['source_port_from'] == $row['source_port_to'] ? $row['source_port_from'] : $row['source_port_from'] . '-' . $row['source_port_to']);
            $listenerPort = ($row['bind_port_from'] == $row['bind_port_to'] ? $row['bind_port_from'] : $row['bind_port_from'] . '-' . $row['bind_port_to']);

            $return[] = [
                $row['network'] . ' (' . $row['net_address'] . ')',
                $row['source_object'],
                $row['source_ip'],
                '<= ' . $row['protocol'] . $layer5 . '/' . $sourcePort . ' =>',
                $listenerPort,
                $row['bind_object'],
                $row['bind_ip'],
                $row['bind_application'] ?: '-',
                $row['source_gateway'] ?: '-',
                $row['bind_gateway'] ?: '-',
            ];
        }

        header('Content-Type: application/json');

        echo isys_format_json::encode($return);

        die;
    }
}
