--
-- i-doit system dump for version 29
--
-- For manual installations you need to insert your tenant connection info into isys_mandator in order to connect to a tenant.
--
-- INSERT INTO isys_mandator SET
--   isys_mandator__title = 'Mandator (DE)',
--   isys_mandator__dir_cache = 'cache_mandator',
--   isys_mandator__dir_tpl = 'default',
--   isys_mandator__db_host = 'localhost',
--   isys_mandator__db_port = 3306,
--   isys_mandator__db_name = 'idoit_data',
--   isys_mandator__db_user = 'idoit',
--   isys_mandator__db_pass = 'idoit',
--   isys_mandator__active = 1;
--

SET FOREIGN_KEY_CHECKS = 0;
SET GLOBAL innodb_default_row_format = DYNAMIC;

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_const_get` (
  `isys_const_get__id` int(11) NOT NULL AUTO_INCREMENT,
  `isys_const_get__title` varchar(255) NOT NULL DEFAULT '',
  `isys_const_get__description` text DEFAULT NULL,
  `isys_const_get__value` text DEFAULT NULL,
  `isys_const_get__quoted` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`isys_const_get__id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `isys_const_get` VALUES (1,'C__CMDB__GET__VIEWMODE',NULL,'viewMode',1);
INSERT INTO `isys_const_get` VALUES (2,'C__CMDB__GET__TREEMODE',NULL,'tvMode',1);
INSERT INTO `isys_const_get` VALUES (3,'C__CMDB__GET__OBJECTGROUP',NULL,'objGroupID',1);
INSERT INTO `isys_const_get` VALUES (4,'C__CMDB__GET__OBJECTTYPE',NULL,'objTypeID',1);
INSERT INTO `isys_const_get` VALUES (5,'C__CMDB__GET__OBJECT',NULL,'objID',1);
INSERT INTO `isys_const_get` VALUES (6,'C__CMDB__GET__CATTYPE',NULL,'catTypeID',1);
INSERT INTO `isys_const_get` VALUES (7,'C__CMDB__GET__CATG',NULL,'catgID',1);
INSERT INTO `isys_const_get` VALUES (8,'C__CMDB__GET__CATS',NULL,'catsID',1);
INSERT INTO `isys_const_get` VALUES (9,'C__CMDB__GET__CATD',NULL,'catdID',1);
INSERT INTO `isys_const_get` VALUES (10,'C__CMDB__GET__POPUP',NULL,'popup',1);
INSERT INTO `isys_const_get` VALUES (11,'C__CMDB__GET__CAT_MENU_SELECTION',NULL,'catMenuSelection',1);
INSERT INTO `isys_const_get` VALUES (12,'C__CMDB__GET__EDITMODE',NULL,'editMode',1);
INSERT INTO `isys_const_get` VALUES (13,'C__CMDB__GET__CAT_LIST_VIEW',NULL,'catListView',1);
INSERT INTO `isys_const_get` VALUES (14,'C__CMDB__GET__CATLEVEL',NULL,'cateID',1);
INSERT INTO `isys_const_get` VALUES (15,'C__CMDB__GET__CATLEVEL_1',NULL,'cat1ID',1);
INSERT INTO `isys_const_get` VALUES (16,'C__CMDB__GET__CATLEVEL_2',NULL,'cat2ID',1);
INSERT INTO `isys_const_get` VALUES (17,'C__CMDB__GET__CATLEVEL_3',NULL,'cat3ID',1);
INSERT INTO `isys_const_get` VALUES (18,'C__CMDB__GET__CATLEVEL_4',NULL,'cat4ID',1);
INSERT INTO `isys_const_get` VALUES (19,'C__CMDB__GET__CATLEVEL_5',NULL,'cat5ID',1);
INSERT INTO `isys_const_get` VALUES (20,'C__CMDB__GET__CATLEVEL_MAX',NULL,'5',1);
INSERT INTO `isys_const_get` VALUES (21,'C__GET__FILE_MANAGER',NULL,'file_manager',1);
INSERT INTO `isys_const_get` VALUES (22,'C__GET__MODULE_ID',NULL,'moduleID',1);
INSERT INTO `isys_const_get` VALUES (23,'C__GET__NAVMODE',NULL,'navMode',1);
INSERT INTO `isys_const_get` VALUES (24,'C__GET__FILE_NAME',NULL,'file_name',1);
INSERT INTO `isys_const_get` VALUES (25,'C__GET__AJAX_REQUEST',NULL,'ajax_request_func',1);
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_const_system` (
  `isys_const_system__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_const_system__const` varchar(255) NOT NULL DEFAULT '',
  `isys_const_system__value` int(10) unsigned DEFAULT 1,
  `isys_const_system__description` text DEFAULT NULL,
  `isys_const_system__store_id` int(10) unsigned NOT NULL DEFAULT 0,
  `isys_const_system__doku_cross_reference` text DEFAULT NULL,
  PRIMARY KEY (`isys_const_system__id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `isys_const_system` VALUES (1,'C__NAVBAR_BUTTON__DELETE',5,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (3,'C__NAVMODE__NEW',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (4,'C__NAVMODE__EDIT',2,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (5,'C__NAVMODE__DUPLICATE',3,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (7,'C__NAVMODE__BACK',7,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (8,'C__NAVMODE__FORWARD',9,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (9,'C__NAVMODE__SAVE',10,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (10,'C__NAVMODE__RESET',13,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (11,'C__NAVMODE__CANCEL',14,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (29,'C__RECORD_PROPERTY__NOT_SHOW_IN_LIST',16,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (40,'C__NAVBAR_BUTTON__NEW',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (41,'C__NAVBAR_BUTTON__EDIT',2,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (43,'C__NAVBAR_BUTTON__DUPLICATE',3,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (45,'C__NAVBAR_BUTTON__BACK',7,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (47,'C__NAVBAR_BUTTON__FORWARD',9,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (48,'C__RECORD_STATUS__BIRTH',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (49,'C__RECORD_STATUS__NORMAL',2,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (50,'C__RECORD_STATUS__ARCHIVED',3,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (51,'C__RECORD_STATUS__DELETED',4,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (54,'C__EDITMODE__ON',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (55,'C__EDITMODE__OFF',0,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (56,'C__NAVBAR_BUTTON__RECYCLE',12,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (59,'C__RECORD_STATUS__PURGE',5,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (60,'C__MPTT__ACTION_BEGIN',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (61,'C__MPTT__ACTION_END',6,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (62,'C__MPTT__ACTION_ADD',2,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (63,'C__MPTT__ACTION_DELETE',3,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (64,'C__MPTT__ACTION_MOVE',4,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (65,'C__MPTT__ROOT_NODE',1,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (66,'C__MPTT__ACTION_UPDATE',5,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (72,'C__NAVMODE__ARCHIVE',4,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (73,'C__NAVBAR_BUTTON__ARCHIVE',4,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (74,'C__NAVMODE__PURGE',6,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (75,'C__NAVBAR_BUTTON__PURGE',6,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (76,'C__NAVMODE__RECYCLE',12,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (77,'C__LINK__OBJECT',1,NULL,1,NULL);
INSERT INTO `isys_const_system` VALUES (80,'C__LINK__CATG',2,NULL,1,NULL);
INSERT INTO `isys_const_system` VALUES (83,'C__NAVMODE__PRINT',15,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (84,'C__NAVBAR_BUTTON__PRINT',15,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (85,'C__NAVMODE__DELETE',5,'',0,NULL);
INSERT INTO `isys_const_system` VALUES (86,'C__NAVMODE__JS_ACTION',16,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (87,'C__RECORD_STATUS__TEMPLATE',6,'',0,NULL);
INSERT INTO `isys_const_system` VALUES (88,'C__NAVBAR_BUTTON__COMPLETE',20,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (89,'C__NAVMODE__COMPLETE',20,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (90,'C__RECORD_STATUS__MASS_CHANGES_TEMPLATE',7,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (91,'C__NAVBAR_BUTTON__SAVE',21,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (92,'C__NAVBAR_BUTTON__CANCEL',22,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (93,'C__NAVBAR_BUTTON__QUICK_PURGE',60,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (94,'C__NAVMODE__QUICK_PURGE',60,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (95,'C__NAVBAR_BUTTON__EXPORT_AS_CSV',17,NULL,0,NULL);
INSERT INTO `isys_const_system` VALUES (96,'C__NAVMODE__EXPORT_CSV',17,NULL,0,NULL);
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_db_init` (
  `isys_db_init__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_db_init__key` varchar(255) NOT NULL,
  `isys_db_init__value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`isys_db_init__id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `isys_db_init` VALUES (1,'title','i-doit 29');
INSERT INTO `isys_db_init` VALUES (2,'revision','202429000');
INSERT INTO `isys_db_init` VALUES (3,'version','29');
INSERT INTO `isys_db_init` VALUES (4,'type','pro');
INSERT INTO `isys_db_init` VALUES (5,'required_revision','202220000');
INSERT INTO `isys_db_init` VALUES (6,'required_version','20');
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_language` (
  `isys_language__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_language__title` varchar(255) DEFAULT NULL,
  `isys_language__short` varchar(8) NOT NULL,
  `isys_language__icon` varchar(255) DEFAULT NULL,
  `isys_language__available` int(1) NOT NULL,
  `isys_language__const` varchar(100) DEFAULT NULL,
  `isys_language__sort` int(10) NOT NULL,
  PRIMARY KEY (`isys_language__id`),
  UNIQUE KEY `isys_language__short` (`isys_language__short`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `isys_language` VALUES (2,'LC__LANGUAGE_GERMAN','de','axialis/flags-languages/flag-germany.svg',1,'ISYS_LANGUAGE_GERMAN',1);
INSERT INTO `isys_language` VALUES (3,'LC__LANGUAGE_ENGLISH','en','axialis/flags-languages/flag-united-states.svg',1,'ISYS_LANGUAGE_ENGLISH',2);
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_licence` (
  `isys_licence__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_licence__isys_mandator__id` int(10) unsigned DEFAULT NULL,
  `isys_licence__isys_licence__id` int(10) unsigned DEFAULT NULL,
  `isys_licence__contract` varchar(10) DEFAULT NULL,
  `isys_licence__type` int(10) NOT NULL,
  `isys_licence__key` longtext DEFAULT NULL,
  `isys_licence__data` longtext DEFAULT NULL,
  `isys_licence__expires` datetime DEFAULT NULL,
  `isys_licence__datetime` datetime DEFAULT NULL,
  `isys_licence__license_objects` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`isys_licence__id`),
  KEY `isys_licence__isys_mandator__id` (`isys_licence__isys_mandator__id`),
  CONSTRAINT `isys_licence_ibfk_1` FOREIGN KEY (`isys_licence__isys_mandator__id`) REFERENCES `isys_mandator` (`isys_mandator__id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_licence_communication` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` int(3) unsigned NOT NULL,
  `licenses_count` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_mandator` (
  `isys_mandator__id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isys_mandator__title` varchar(255) DEFAULT NULL,
  `isys_mandator__description` text DEFAULT NULL,
  `isys_mandator__dir_cache` varchar(255) DEFAULT NULL,
  `isys_mandator__dir_tpl` varchar(255) DEFAULT NULL,
  `isys_mandator__db_host` varchar(255) DEFAULT NULL,
  `isys_mandator__db_port` int(11) DEFAULT 3306,
  `isys_mandator__db_name` varchar(255) DEFAULT NULL,
  `isys_mandator__db_user` varchar(255) NOT NULL DEFAULT '',
  `isys_mandator__db_pass` varchar(255) DEFAULT NULL,
  `isys_mandator__db_password` varchar(255) DEFAULT NULL,
  `isys_mandator__apikey` varchar(100) DEFAULT NULL,
  `isys_mandator__sort` int(10) unsigned DEFAULT NULL,
  `isys_mandator__active` int(10) unsigned DEFAULT 1,
  `isys_mandator__license_objects` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`isys_mandator__id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `isys_settings` (
  `isys_settings__key` varchar(255) NOT NULL,
  `isys_settings__value` text NOT NULL,
  `isys_settings__isys_mandator__id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`isys_settings__key`,`isys_settings__isys_mandator__id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `isys_settings` VALUES ('admin.active_license_distribution','1',0);
INSERT INTO `isys_settings` VALUES ('api.authenticated-users-only','0',0);
INSERT INTO `isys_settings` VALUES ('api.status','1',0);
INSERT INTO `isys_settings` VALUES ('api.strip-tags','0',0);
INSERT INTO `isys_settings` VALUES ('api.validation','1',0);
INSERT INTO `isys_settings` VALUES ('auth.active','1',0);
INSERT INTO `isys_settings` VALUES ('auth.logging','0',0);
INSERT INTO `isys_settings` VALUES ('auth.use-in-cmdb-explorer','0',0);
INSERT INTO `isys_settings` VALUES ('barcode.enabled','1',0);
INSERT INTO `isys_settings` VALUES ('barcode.type','qr',0);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__CMDB__OBJTYPE__CABLE_TRAY','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__CMDB__OBJTYPE__CONDUIT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJECT_TYPE__GROUP','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ACCESS_POINT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"ssid\",\"isys_cats_access_point_list__ssid\",\"LC__CMDB__CATS__ACCESS_POINT_SSID\",\"isys_cmdb_dao_category_s_access_point::get_properties\",false,\"LC__CMDB__CATS__ACCESS_POINT\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__AIR_CONDITION_SYSTEM','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"type\",\"isys_ac_type__title\",\"LC__CATS__AC_TYPE\",\"isys_cmdb_dao_category_s_ac::get_properties\",false,\"LC__CMDB__CATS__AC\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__AIRCRAFT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__AMPLIFIER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__APPLIANCE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"all_ips\",\"isys_catg_ip_list__isys_cats_net_ip_addresses_list__id\",\"LC__CMDB__CATG__CLUSTER_SERVICE__HOST_ADDRESSES\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__APPLICATION','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_application_manufacturer__title\",\"LC__CMDB__CATG__MANUFACTURE\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"installation_count\",null,\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__BLADE_CHASSIS','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"title\",\"isys_cats_chassis_slot_list__title\",\"LC__CMDB__CATG__GLOBAL_TITLE\",\"isys_cmdb_dao_category_s_chassis_slot::get_properties\",false,\"LC__CMDB__CATS__CHASSIS_SLOTS\",null],[1,\"assigned_devices\",\"isys_cats_chassis_slot_list__id\",\"LC__CMDB__CATS__CHASSIS__ASSIGNED_DEVICES\",\"isys_cmdb_dao_category_s_chassis_slot::get_properties\",false,\"LC__CMDB__CATS__CHASSIS_SLOTS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__BLADE_SERVER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__BUILDING','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"street\",\"isys_catg_address_list__street\",\"LC__CONTACT__ORGANISATION_STREET\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"postcode\",\"isys_catg_address_list__postalcode\",\"LC__CONTACT__ORGANISATION_POSTAL_CODE\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"city\",\"isys_catg_address_list__city\",\"LC__CONTACT__ORGANISATION_CITY\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CABLE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"connection\",\"isys_catg_cable_list__id__isys_obj__id\",\"LC__CATS__CABLE__CONNECTION\",\"isys_cmdb_dao_category_g_cable::get_properties\",false,\"LC__CATG__CABLE\",null],[1,\"cable_type\",\"isys_cable_type__title\",\"LC__CMDB__CATS__CABLE__TYPE\",\"isys_cmdb_dao_category_g_cable::get_properties\",false,\"LC__CATG__CABLE\",null],[1,\"length\",\"isys_catg_cable_list__length\",\"LC__CMDB__CATS__CABLE__LENGTH\",\"isys_cmdb_dao_category_g_cable::get_properties\",false,\"LC__CATG__CABLE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CELL_PHONE_CONTRACT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"serial\",\"isys_catg_model_list__serial\",\"LC__CMDB__CATG__SERIAL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"imei_number\",\"isys_cats_mobile_phone_list__imei_number\",\"LC__CMDB__CATS__SIM_CARD__IMEI_NUMBER\",\"isys_cmdb_dao_category_s_cp_contract::get_properties\",false,\"LC__CMDB__CATS__CELL_PHONE_CONTRACT\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CITY','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CLIENT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_contact\",\"isys_connection__title\",\"LC__CATG__CONTACT_PRIMARY\",\"isys_cmdb_dao_category_g_contact::get_properties\",false,\"LC__CMDB__CATG__CONTACT\",null],[1,\"type\",\"isys_client_type__title\",\"LC__CMDB__CATS__CLIENT_TYPE\",\"isys_cmdb_dao_category_s_client::get_properties\",false,\"LC__CMDB__CATS__CLIENT\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CLUSTER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cluster_members\",\"isys_catg_cluster_members_list__isys_obj__id\",\"LC__CMDB__CATG__CLUSTER_MEMBERS\",\"isys_cmdb_dao_category_g_cluster::get_properties\",false,\"LC__CMDB__CATG__CLUSTER\",null],[1,\"cluster_service\",\"isys_catg_cluster_service_list__isys_obj__id\",\"LC__CMDB__CATG__CLUSTER_SERVICES\",\"isys_cmdb_dao_category_g_cluster::get_properties\",false,\"LC__CMDB__CATG__CLUSTER\",null],[1,\"administration_service\",\"isys_catg_cluster_adm_service_list__isys_obj__id\",\"LC__CMDB__CATG__CLUSTER__ADMINISTRATION_SERVICE\",\"isys_cmdb_dao_category_g_cluster::get_properties\",false,\"LC__CMDB__CATG__CLUSTER\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CLUSTER_SERVICE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cluster\",\"isys_catg_cluster_service_list__isys_obj__id\",\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\",\"isys_cmdb_dao_category_s_cluster_service::get_properties\",false,\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\",null],[1,\"runs_on\",\"isys_catg_cluster_service_list__id\",\"LC__CMDB__CATG__CLUSTER_SERVICE__RUNS_ON\",\"isys_cmdb_dao_category_s_cluster_service::get_properties\",false,\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\",null],[1,\"type\",\"isys_cluster_type__title\",\"LC__CMDB__CATG__CLUSTER_SERVICE__TYPE\",\"isys_cmdb_dao_category_s_cluster_service::get_properties\",false,\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CLUSTER_VRRP_HSRP','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__CONVERTER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__COUNTRY','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__DATABASE_INSTANCE','[[1,\"title\",\"isys_obj__title\",\"Name (Allgemein)\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"title\",\"isys_cats_database_instance_list__title\",\"Name (Instanz \\/ Oracle Datenbank)\",\"isys_cmdb_dao_category_s_database_instance::get_properties\",false,\"LC__CMDB__TREE__DATABASE_INSTANCE\",null],[1,\"listener\",\"isys_cats_database_instance_list__listener\",\"Listener\",\"isys_cmdb_dao_category_s_database_instance::get_properties\",false,\"LC__CMDB__TREE__DATABASE_INSTANCE\",null],[1,\"instance\",\"isys_connection__title\",\"DBMS\",\"isys_cmdb_dao_category_s_database_instance::get_properties\",false,\"LC__CMDB__TREE__DATABASE_INSTANCE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__DATABASE_SCHEMA','[[1,\"title\",\"isys_obj__title\",\"Name (Allgemein)\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"storage_engine\",\"isys_cats_database_schema_list__storage_engine\",\"Storage-Engine\",\"isys_cmdb_dao_category_s_database_schema::get_properties\",false,\"LC__OBJTYPE__DATABASE_SCHEMA\",null],[1,\"title\",\"isys_cats_database_objects_list__title\",\"Name (Datenbankobjekte)\",\"isys_cmdb_dao_category_s_database_objects::get_properties\",false,\"LC__CMDB__TREE__DATABASE_OBJECTS\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__DBMS','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_application_manufacturer__title\",\"LC__CMDB__CATG__MANUFACTURE\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"installation_count\",null,\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__DISTRIBUTION_BOX','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__EMERGENCY_PLAN','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ENCLOSURE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"rackunits\",\"isys_catg_formfactor_list__rackunits\",\"LC__CMDB__CATG__RACKUNITS\",\"isys_cmdb_dao_category_g_formfactor::get_properties\",false,\"LC__CMDB__CATG__FORMFACTOR\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"vertical_slots_front\",\"isys_cats_enclosure_list__vertical_slots_front\",\"LC__CMDB__CATS__ENCLOSURE__VERTICAL_SLOTS_FRONTSIDE\",\"isys_cmdb_dao_category_s_enclosure::get_properties\",false,\"LC__CMDB__CATS__ENCLOSURE\",null],[1,\"vertical_slots_rear\",\"isys_cats_enclosure_list__vertical_slots_rear\",\"LC__CMDB__CATS__ENCLOSURE__VERTICAL_SLOTS_BACKSIDE\",\"isys_cmdb_dao_category_s_enclosure::get_properties\",false,\"LC__CMDB__CATS__ENCLOSURE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__EPS','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ESC','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"volt\",\"isys_catg_power_supplier_list__volt\",\"LC__CMDB__CATG__POWER_SUPPLIER__VOLT\",\"isys_cmdb_dao_category_g_power_supplier::get_properties\",false,\"LC__CMDB__CATG__POWER_SUPPLIER\",null],[1,\"watt\",\"isys_catg_power_supplier_list__watt\",\"LC__CMDB__CATG__POWER_SUPPLIER__WATT\",\"isys_cmdb_dao_category_g_power_supplier::get_properties\",false,\"LC__CMDB__CATG__POWER_SUPPLIER\",null],[1,\"ampere\",\"isys_catg_power_supplier_list__ampere\",\"LC__CMDB__CATG__POWER_SUPPLIER__AMPERE\",\"isys_cmdb_dao_category_g_power_supplier::get_properties\",false,\"LC__CMDB__CATG__POWER_SUPPLIER\",null],[1,\"connector\",\"con_connector\",\"LC__CATG__CONNECTOR__ASSIGNED_CONNECTOR\",\"isys_cmdb_dao_category_g_power_supplier::get_properties\",false,\"LC__CMDB__CATG__POWER_SUPPLIER\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__FC_SWITCH','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"target\",\"isys_catg_fc_port_list__isys_catg_connector_list__id\",\"LC__CMDB__CATG__NETWORK__TARGET_OBJECT\",\"isys_cmdb_dao_category_g_controller_fcport::get_properties\",false,\"LC__STORAGE_FCPORT\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__FILE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__HOST','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"all_ips\",\"isys_catg_ip_list__isys_cats_net_ip_addresses_list__id\",\"LC__CMDB__CATG__CLUSTER_SERVICE__HOST_ADDRESSES\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__IT_SERVICE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"its_type\",\"isys_its_type__title\",\"LC__CMDB__CATG__TYPE\",\"isys_cmdb_dao_category_g_its_type::get_properties\",false,\"LC__CMDB__CATG__ITS_TYPE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__KRYPTO_CARD','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"date_of_issue\",\"isys_cats_krypto_card_list__date_of_issue\",\"LC__CMDB__CATS__KRYPTO_CARD__DATE_OF_ISSUE\",\"isys_cmdb_dao_category_s_krypto_card::get_properties\",false,\"LC__CMDB__CATS__KRYPTO_CARD\",null],[1,\"certgate_card_number\",\"isys_cats_krypto_card_list__certgate_card_number\",\"LC__CMDB__CATS__KRYPTO_CARD__CERTGATE_CARD_NUMBER\",\"isys_cmdb_dao_category_s_krypto_card::get_properties\",false,\"LC__CMDB__CATS__KRYPTO_CARD\",null],[1,\"imei_number\",\"isys_cats_krypto_card_list__imei_number\",\"LC__CMDB__CATS__KRYPTO_CARD__IMEI_NUMBER\",\"isys_cmdb_dao_category_s_krypto_card::get_properties\",false,\"LC__CMDB__CATS__KRYPTO_CARD\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__KVM_SWITCH','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__LAYER2_NET','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"vlan_id\",\"isys_cats_layer2_net_list__ident\",\"LC__CMDB__CATS__LAYER2_ID\",\"isys_cmdb_dao_category_s_layer2_net::get_properties\",false,\"LC__CMDB__CATS__LAYER2_NET\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__LAYER3_NET','[[1,\"ip_address_link\",\"isys_cats_net_ip_addresses_link__isys_obj__id\",\"LC__CMDB__IP__URL_TITLE\",\"isys_cmdb_dao_category_s_net_ip_addresses::get_properties\",false,\"LC__CMDB__CATS__NET_IP_ADDRESSES\",null],[1,\"type\",\"isys_net_type__title\",\"LC__CMDB__CATS__NET__TYPE\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"address_with_suffix\",\"isys_obj__id\",\"LC__CMDB__CATS__NET__ADDRESS_WITH_SUFFIX\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"address_range\",\"isys_obj__id\",\"LC__CMDB__CATS__NET__ADDRESS_RANGE\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"netmask\",\"isys_cats_net_list__mask\",\"LC__CMDB__CATS__NET__MASK\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"free_addresses\",\"isys_obj__id\",\"LC__CMDB__CATG__NETWORK__ASS_IP\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__LICENCE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"amount\",\"isys_cats_lic_list__amount\",\"LC__CMDB__CATS__LICENCE_AMOUNT\",\"isys_cmdb_dao_category_s_lic::get_properties\",false,\"LC__CMDB__CATS__LICENCE_LIST\",null],[1,\"lic_not_in_use\",\"isys_cats_lic_list__id\",\"LC__CMDB__CATS__LICENCE_FREE\",\"isys_cmdb_dao_category_s_lic::get_properties\",false,\"LC__CMDB__CATS__LICENCE_LIST\",null],[1,\"type\",\"isys_cats_lic_list__type\",\"LC__CMDB__CATS__LICENCE_TYPE\",\"isys_cmdb_dao_category_s_lic::get_properties\",false,\"LC__CMDB__CATS__LICENCE_LIST\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__MAINTENANCE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"type\",\"isys_contract_type__title\",\"LC__CMDB__CATS__CONTRACT__TYPE\",\"isys_cmdb_dao_category_s_contract::get_properties\",false,\"LC__CMDB__CATS__CONTRACT\",null],[1,\"contract_status\",\"isys_contract_status__title\",\"LC__CMDB__CATS__CONTRACT__STATUS\",\"isys_cmdb_dao_category_s_contract::get_properties\",false,\"LC__CMDB__CATS__CONTRACT\",null],[1,\"run_time\",\"isys_cats_contract_list__runtime\",\"LC__CMDB__CATG__LEASING__RUNTIME\",\"isys_cmdb_dao_category_s_contract::get_properties\",false,\"LC__CMDB__CATS__CONTRACT\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__MIDDLEWARE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_application_manufacturer__title\",\"LC__CMDB__CATG__MANUFACTURE\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__MIGRATION_OBJECT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__MONITOR','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__NAGIOS_HOST_TPL','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__NAGIOS_SERVICE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__NAGIOS_SERVICE_TPL','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__OPERATING_SYSTEM','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_application_manufacturer__title\",\"LC__CMDB__CATG__MANUFACTURE\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"installation_count\",null,\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\",\"isys_cmdb_dao_category_s_application::get_properties\",false,\"LC__CMDB__CATS__APPLICATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ORGANIZATION','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"street\",\"isys_catg_address_list__street\",\"LC__CONTACT__ORGANISATION_STREET\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"postcode\",\"isys_catg_address_list__postalcode\",\"LC__CONTACT__ORGANISATION_POSTAL_CODE\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"city\",\"isys_catg_address_list__city\",\"LC__CONTACT__ORGANISATION_CITY\",\"isys_cmdb_dao_category_g_address::get_properties\",false,\"LC__CATG__ADDRESS\",null],[1,\"telephone\",\"isys_cats_organization_list__telephone\",\"LC__CONTACT__ORGANISATION_PHONE\",\"isys_cmdb_dao_category_s_organization_master::get_properties\",false,\"LC__CMDB__CATS__ORGANIZATION_MASTER_DATA\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PARALLEL_RELATION','[[1,\"title\",false,\"LC__UNIVERSAL__TITLE_LINK\",\"isys_cmdb_dao_category_g_global::get_properties\",[\"isys_cmdb_dao_category_g_global\",\"dynamic_property_callback_title\"],null,null],[1,\"threshold\",\"isys_cats_relpool_list__threshold\",\"LC__CATS__AC_THRESHOLD\",\"isys_cmdb_dao_category_s_parallel_relation::get_properties\",false,null,null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PATCH_PANEL','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PDU','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"title\",\"isys_catg_connector_list__title\",\"LC__CMDB__CATG__TITLE\",\"isys_cmdb_dao_category_g_connector::get_properties\",false,\"LC__CMDB__CATG__CONNECTORS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PERSON','[[1,\"last_name\",\"isys_cats_person_list__last_name\",\"LC__CONTACT__PERSON_LAST_NAME\",\"isys_cmdb_dao_category_s_person_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"first_name\",\"isys_cats_person_list__first_name\",\"LC__CONTACT__PERSON_FIRST_NAME\",\"isys_cmdb_dao_category_s_person_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"department\",\"isys_cats_person_list__department\",\"LC__CONTACT__PERSON_DEPARTMENT\",\"isys_cmdb_dao_category_s_person_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"phone_company\",\"isys_cats_person_list__phone_company\",\"LC__CONTACT__PERSON_TELEPHONE_COMPANY\",\"isys_cmdb_dao_category_s_person_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"mail\",\"isys_catg_mail_addresses_list__title\",\"LC__CONTACT__PERSON_MAIL_ADDRESS\",\"isys_cmdb_dao_category_s_person_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"title\",\"isys_cats_person_list__title\",\"LC__CONTACT__PERSON_USER_NAME\",\"isys_cmdb_dao_category_s_person_login::get_properties\",false,\"LC__UNIVERSAL__LOGIN\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PERSON_GROUP','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"email_address\",\"isys_catg_mail_addresses_list__title\",\"LC__CONTACT__GROUP_EMAIL_ADDRESS\",\"isys_cmdb_dao_category_s_person_group_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"phone\",\"isys_cats_person_group_list__phone\",\"LC__CONTACT__GROUP_PHONE\",\"isys_cmdb_dao_category_s_person_group_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null],[1,\"ldap_group\",\"isys_cats_person_group_list__ldap_group\",\"LC__CMDB__CATS__PERSON_GROUPS__LDAP_MAPPING\",\"isys_cmdb_dao_category_s_person_group_master::get_properties\",false,\"LC__CONTACT__TREE__MASTER_DATA\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PHONE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"extension\",\"isys_catg_telephone_fax_list__extension\",\"LC__CMDB__CATG__TELEPHONE_FAX__EXTENSION\",\"isys_cmdb_dao_category_g_telephone_fax::get_properties\",false,\"LC__CMDB__CATG__TELEPHONE_FAX\",null],[1,\"telephone_number\",\"isys_catg_telephone_fax_list__telephone_number\",\"LC__CMDB__CATG__TELEPHONE_FAX__TELEPHONE_NUMBER\",\"isys_cmdb_dao_category_g_telephone_fax::get_properties\",false,\"LC__CMDB__CATG__TELEPHONE_FAX\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PRINTBOX','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__PRINTER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"type\",\"isys_cats_prt_type__title\",\"LC__CMDB__CATS__PRT_TYPE\",\"isys_cmdb_dao_category_s_prt::get_properties\",false,\"LC__CMDB__CATS__PRT\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__RELATION','[[1,\"relation_type\",\"isys_relation_type__title\",\"LC__CATG__RELATION__RELATION_TYPE\",\"isys_cmdb_dao_category_g_relation::get_properties\",false,null,null],[1,\"weighting\",\"isys_weighting__title\",\"LC__CATG__RELATION__WEIGHTING\",\"isys_cmdb_dao_category_g_relation::get_properties\",false,null,null],[1,\"itservice\",false,\"LC__CMDB__CATG__IT_SERVICE\",\"isys_cmdb_dao_category_g_relation::get_properties\",[\"isys_cmdb_dao_category_g_relation\",\"dynamic_property_callback_itservice\"],null,null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__REPLICATION','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"replication_mechanism\",\"isys_replication_mechanism__title\",\"LC__CMDB__CATS__REPLICATION__MECHANISM\",\"isys_cmdb_dao_category_s_replication::get_properties\",false,\"LC__CATS__REPLICATION\",null],[1,\"replication_partner\",\"isys_connection__title\",\"LC__CATS__REPLICATION_PARTNER\",\"isys_cmdb_dao_category_s_replication_partner::get_properties\",false,\"LC__CATS__REPLICATION_PARTNER\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__RM_CONTROLLER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ROOM','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"number\",\"isys_cats_room_list__number\",\"LC__CMDB__CATS__ROOM_NUMBER\",\"isys_cmdb_dao_category_s_room::get_properties\",false,\"LC__CMDB__CATS__ROOM\",null],[1,\"floor\",\"isys_cats_room_list__floor\",\"LC__CMDB__CATS__ROOM_FLOOR\",\"isys_cmdb_dao_category_s_room::get_properties\",false,\"LC__CMDB__CATS__ROOM\",null],[1,\"type\",\"isys_room_type__title\",\"LC__CMDB__CATG__TYPE\",\"isys_cmdb_dao_category_s_room::get_properties\",false,\"LC__CMDB__CATS__ROOM\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__ROUTER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"all_ips\",\"isys_catg_ip_list__isys_cats_net_ip_addresses_list__id\",\"LC__CMDB__CATG__CLUSTER_SERVICE__HOST_ADDRESSES\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SAN','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"description\",\"isys_catg_sanpool_list__description\",\"LC__CMDB__LOGBOOK__DESCRIPTION\",\"isys_cmdb_dao_category_g_sanpool::get_properties\",false,\"LC__CMDB__CATG__LDEV_SERVER\",null],[1,\"lun\",\"isys_catg_sanpool_list__lun\",\"LUN\",\"isys_cmdb_dao_category_g_sanpool::get_properties\",false,\"LC__CMDB__CATG__LDEV_SERVER\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SAN_ZONING','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"members\",\"isys_cats_san_zoning_list__id\",\"LC__CMDB__CATS__SAN_ZONING__MEMBERS\",\"isys_cmdb_dao_category_s_san_zoning::get_properties\",false,\"LC__CMDB__CATS__SAN_ZONING\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SERVER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SERVICE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_application_manufacturer__title\",\"LC__CMDB__CATG__MANUFACTURE\",\"isys_cmdb_dao_category_s_service::get_properties\",false,\"LC__CMDB__CATS__SERVICE\",null],[1,\"installation_count\",null,\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\",\"isys_cmdb_dao_category_s_service::get_properties\",false,\"LC__CMDB__CATS__SERVICE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SIM_CARD','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"type\",\"isys_cp_contract_type__title\",\"LC__CMDB__CATG__TYPE\",\"isys_cmdb_dao_category_g_sim::get_properties\",false,\"LC__CMDB__CATG__SIM\",null],[1,\"assigned_mobile\",\"isys_connection__title\",\"LC__CMDB__CATS__SIM_CARD__ASSIGNED_MOBILE_PHONE\",\"isys_cmdb_dao_category_g_cards::get_properties\",false,\"LC__CMDB__CATG__CARDS\",null],[1,\"network_provider\",\"isys_network_provider__title\",\"LC__CMDB__CATS_CP_CONTRACT__NETWORK_PROVIDER\",\"isys_cmdb_dao_category_g_sim::get_properties\",false,\"LC__CMDB__CATG__SIM\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__STACKING','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SUPERNET','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"type\",\"isys_net_type__title\",\"LC__CMDB__CATS__NET__TYPE\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"address_with_suffix\",\"isys_obj__id\",\"LC__CMDB__CATS__NET__ADDRESS_WITH_SUFFIX\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"address_range\",\"isys_obj__id\",\"LC__CMDB__CATS__NET__ADDRESS_RANGE\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"netmask\",\"isys_cats_net_list__mask\",\"LC__CMDB__CATS__NET__MASK\",\"isys_cmdb_dao_category_s_net::get_properties\",false,\"LC__CMDB__CATS__NET\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SWITCH','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__SWITCH_CHASSIS','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"title\",\"isys_cats_chassis_slot_list__title\",\"LC__CMDB__CATG__GLOBAL_TITLE\",\"isys_cmdb_dao_category_s_chassis_slot::get_properties\",false,\"LC__CMDB__CATS__CHASSIS_SLOTS\",null],[1,\"assigned_devices\",\"isys_cats_chassis_slot_list__id\",\"LC__CMDB__CATS__CHASSIS__ASSIGNED_DEVICES\",\"isys_cmdb_dao_category_s_chassis_slot::get_properties\",false,\"LC__CMDB__CATS__CHASSIS_SLOTS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__TELEPHONE_SYSTEM','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__UPS','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"type\",\"isys_ups_type__title\",\"LC__CMDB__CATS__UPS__TYPE\",\"isys_cmdb_dao_category_s_ups::get_properties\",false,\"LC__CMDB__OBJTYPE__UPS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VEHICLE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VIRTUAL_CLIENT','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_contact\",\"isys_connection__title\",\"LC__CATG__CONTACT_PRIMARY\",\"isys_cmdb_dao_category_g_contact::get_properties\",false,\"LC__CMDB__CATG__CONTACT\",null],[1,\"hosts\",\"vm_obj\",\"LC__CMDB__CATG__VM__RUNNING_ON_HOST\",\"isys_cmdb_dao_category_g_virtual_machine::get_properties\",false,\"LC__CMDB__CATG__VIRTUAL_MACHINE\",null],[1,\"primary\",\"isys_catg_virtual_machine_list__primary\",\"LC__CMDB__HOST_IN_CLUSTER\",\"isys_cmdb_dao_category_g_virtual_machine::get_properties\",false,\"LC__CMDB__CATG__VIRTUAL_MACHINE\",null],[1,\"system\",\"isys_vm_type__title\",\"LC__CMDB__CATG__VIRTUALIZATION_SYSTEM\",\"isys_cmdb_dao_category_g_virtual_machine::get_properties\",false,\"LC__CMDB__CATG__VIRTUAL_MACHINE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VIRTUAL_HOST','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"connected_object\",\"isys_catg_virtual_machine_list__isys_obj__id\",\"LC__CMDB__CATG__GUEST_SYSTEMS\",\"isys_cmdb_dao_category_g_guest_systems::get_properties\",false,\"LC__CMDB__CATG__GUEST_SYSTEMS\",null],[1,\"manufacturer\",\"isys_model_manufacturer__title\",\"LC__CATG__STORAGE_MANUFACTURER\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"title\",\"isys_model_title__title\",\"LC__CMDB__CATG__MODEL\",\"isys_cmdb_dao_category_g_model::get_properties\",false,\"LC__CMDB__CATG__MODEL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VIRTUAL_SERVER','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"primary_hostaddress\",\"isys_cats_net_ip_addresses_list__title\",\"LC__CATG__IP__PRIMARY_ADDRESS\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary_hostname\",\"isys_catg_ip_list__hostname\",\"LC__CATP__IP__PRIMARY_HOSTNAME\",\"isys_cmdb_dao_category_g_ip::get_properties\",false,\"LC__CATG__IP_ADDRESS\",null],[1,\"primary\",\"isys_catg_virtual_machine_list__primary\",\"LC__CMDB__HOST_IN_CLUSTER\",\"isys_cmdb_dao_category_g_virtual_machine::get_properties\",false,\"LC__CMDB__CATG__VIRTUAL_MACHINE\",null],[1,\"hosts\",\"vm_obj\",\"LC__CMDB__CATG__VM__RUNNING_ON_HOST\",\"isys_cmdb_dao_category_g_virtual_machine::get_properties\",false,\"LC__CMDB__CATG__VIRTUAL_MACHINE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VOIP_PHONE','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__VRRP','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"created\",\"isys_obj__created\",\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"changed\",\"isys_obj__updated\",\"LC__CMDB__LAST_CHANGE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__WAN','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"role\",\"isys_wan_role__title\",\"LC__CATG__WAN__ROLE\",\"isys_cmdb_dao_category_g_wan::get_properties\",false,\"LC__CATG__WAN\",null],[1,\"type\",\"isys_wan_type__title\",\"LC__CATG__WAN__TYPE\",\"isys_cmdb_dao_category_g_wan::get_properties\",false,\"LC__CATG__WAN\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__WIRING_SYSTEM','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"title\",\"isys_net_type_title__title\",\"LC__CMDB__CATS__WS_NET_TYPE\",\"isys_cmdb_dao_category_s_ws_net_type::get_properties\",false,\"LC__CMDB__CATS__WS_NET_TYPE\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-list.config.C__OBJTYPE__WORKSTATION','[[1,\"title\",\"isys_obj__title\",\"LC__UNIVERSAL__TITLE\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null],[1,\"parent\",\"isys_catg_logical_unit_list__isys_obj__id__parent\",\"LC__CMDB__CATG__LOGICAL_UNIT__PARENT\",\"isys_cmdb_dao_category_g_logical_unit::get_properties\",false,\"LC__CMDB__CATG__LOGICAL_UNIT\",null],[1,\"assigned_object\",\"isys_obj__title\",\"LC_UNIVERSAL__OBJECT\",\"isys_cmdb_dao_category_g_assigned_logical_unit::get_properties\",false,\"LC__CMDB__CATG__ASSIGNED_LOGICAL_UNITS\",null],[1,\"location_path\",\"isys_catg_location_list__parentid\",\"LC__CMDB__CATG__LOCATION_PATH\",\"isys_cmdb_dao_category_g_location::get_properties\",false,\"LC__CMDB__CATG__LOCATION\",null],[1,\"cmdb_status\",\"isys_cmdb_status__title\",\"LC__UNIVERSAL__CMDB_STATUS\",\"isys_cmdb_dao_category_g_global::get_properties\",false,\"LC__CMDB__CATG__GLOBAL\",null]]',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__CMDB__OBJTYPE__CABLE_TRAY','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__CMDB__OBJTYPE__CONDUIT','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJECT_TYPE__GROUP','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:2:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ACCESS_POINT','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:37:\"isys_cmdb_dao_category_s_access_point\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"ssid\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:28:\"LC__CMDB__CATS__ACCESS_POINT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:33:\"LC__CMDB__CATS__ACCESS_POINT_SSID\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__AIR_CONDITION_SYSTEM','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_s_ac\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:18:\"LC__CMDB__CATS__AC\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:17:\"LC__CATS__AC_TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__AIRCRAFT','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__AMPLIFIER','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__APPLIANCE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:7:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"all_ips\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:47:\"LC__CMDB__CATG__CLUSTER_SERVICE__HOST_ADDRESSES\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"primary_hostname\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATP__IP__PRIMARY_HOSTNAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:6;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__APPLICATION','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:4:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_application\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATS__APPLICATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:27:\"LC__CMDB__CATG__MANUFACTURE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_application\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:18:\"installation_count\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATS__APPLICATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:46:\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__BLADE_CHASSIS','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:37:\"isys_cmdb_dao_category_s_chassis_slot\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:29:\"LC__CMDB__CATS__CHASSIS_SLOTS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:28:\"LC__CMDB__CATG__GLOBAL_TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:37:\"isys_cmdb_dao_category_s_chassis_slot\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"assigned_devices\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:29:\"LC__CMDB__CATS__CHASSIS_SLOTS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:41:\"LC__CMDB__CATS__CHASSIS__ASSIGNED_DEVICES\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_list\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__BLADE_SERVER','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:7:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:19:\"primary_hostaddress\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CATG__IP__PRIMARY_ADDRESS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"primary_hostname\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATP__IP__PRIMARY_HOSTNAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:6;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__BUILDING','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_address\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:6:\"street\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:17:\"LC__CATG__ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:32:\"LC__CONTACT__ORGANISATION_STREET\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_address\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:8:\"postcode\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:17:\"LC__CATG__ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:37:\"LC__CONTACT__ORGANISATION_POSTAL_CODE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_address\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"city\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:17:\"LC__CATG__ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CONTACT__ORGANISATION_CITY\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CABLE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_cable\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:10:\"connection\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:15:\"LC__CATG__CABLE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:27:\"LC__CATS__CABLE__CONNECTION\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_cable\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:10:\"cable_type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:15:\"LC__CATG__CABLE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:27:\"LC__CMDB__CATS__CABLE__TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_cable\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:6:\"length\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:15:\"LC__CATG__CABLE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATS__CABLE__LENGTH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:5:\"float\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CELL_PHONE_CONTRACT','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:6:\"serial\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:22:\"LC__CMDB__CATG__SERIAL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_cp_contract\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"imei_number\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:35:\"LC__CMDB__CATS__CELL_PHONE_CONTRACT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:37:\"LC__CMDB__CATS__SIM_CARD__IMEI_NUMBER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CITY','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CLIENT','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_contact\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:15:\"primary_contact\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:23:\"LC__CMDB__CATG__CONTACT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CATG__CONTACT_PRIMARY\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_s_client\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATS__CLIENT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:27:\"LC__CMDB__CATS__CLIENT_TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CLUSTER','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_cluster\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:15:\"cluster_members\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:23:\"LC__CMDB__CATG__CLUSTER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:31:\"LC__CMDB__CATG__CLUSTER_MEMBERS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_cluster\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:15:\"cluster_service\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:23:\"LC__CMDB__CATG__CLUSTER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:32:\"LC__CMDB__CATG__CLUSTER_SERVICES\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_cluster\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:22:\"administration_service\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:23:\"LC__CMDB__CATG__CLUSTER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:47:\"LC__CMDB__CATG__CLUSTER__ADMINISTRATION_SERVICE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CLUSTER_SERVICE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:40:\"isys_cmdb_dao_category_s_cluster_service\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"cluster\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:49:\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:49:\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:40:\"isys_cmdb_dao_category_s_cluster_service\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"runs_on\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:49:\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:40:\"LC__CMDB__CATG__CLUSTER_SERVICE__RUNS_ON\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_list\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:40:\"isys_cmdb_dao_category_s_cluster_service\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:49:\"LC__CMDB__CATS__CLUSTER_SERVICE__ASSIGNED_CLUSTER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:37:\"LC__CMDB__CATG__CLUSTER_SERVICE__TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CLUSTER_VRRP_HSRP','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__CONVERTER','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__COUNTRY','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__DATABASE_INSTANCE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:16:\"Name (Allgemein)\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:42:\"isys_cmdb_dao_category_s_database_instance\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:33:\"LC__CMDB__TREE__DATABASE_INSTANCE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:33:\"Name (Instanz / Oracle Datenbank)\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:42:\"isys_cmdb_dao_category_s_database_instance\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:8:\"listener\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:33:\"LC__CMDB__TREE__DATABASE_INSTANCE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:8:\"Listener\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:42:\"isys_cmdb_dao_category_s_database_instance\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:8:\"instance\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:33:\"LC__CMDB__TREE__DATABASE_INSTANCE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:4:\"DBMS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__DATABASE_SCHEMA','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:4:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:16:\"Name (Allgemein)\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:40:\"isys_cmdb_dao_category_s_database_schema\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:14:\"storage_engine\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:28:\"LC__OBJTYPE__DATABASE_SCHEMA\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:14:\"Storage-Engine\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:41:\"isys_cmdb_dao_category_s_database_objects\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:32:\"LC__CMDB__TREE__DATABASE_OBJECTS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:23:\"Name (Datenbankobjekte)\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__DBMS','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:4:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_application\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATS__APPLICATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:27:\"LC__CMDB__CATG__MANUFACTURE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_application\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:18:\"installation_count\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATS__APPLICATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:46:\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__DISTRIBUTION_BOX','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__EMERGENCY_PLAN','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:2:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ENCLOSURE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:35:\"isys_cmdb_dao_category_g_formfactor\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:9:\"rackunits\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:26:\"LC__CMDB__CATG__FORMFACTOR\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CMDB__CATG__RACKUNITS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:34:\"isys_cmdb_dao_category_s_enclosure\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:20:\"vertical_slots_front\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:25:\"LC__CMDB__CATS__ENCLOSURE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:51:\"LC__CMDB__CATS__ENCLOSURE__VERTICAL_SLOTS_FRONTSIDE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:34:\"isys_cmdb_dao_category_s_enclosure\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:19:\"vertical_slots_rear\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:25:\"LC__CMDB__CATS__ENCLOSURE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:50:\"LC__CMDB__CATS__ENCLOSURE__VERTICAL_SLOTS_BACKSIDE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__EPS','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ESC','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:7:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:39:\"isys_cmdb_dao_category_g_power_supplier\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"volt\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CMDB__CATG__POWER_SUPPLIER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:36:\"LC__CMDB__CATG__POWER_SUPPLIER__VOLT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:39:\"isys_cmdb_dao_category_g_power_supplier\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"watt\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CMDB__CATG__POWER_SUPPLIER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:36:\"LC__CMDB__CATG__POWER_SUPPLIER__WATT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:39:\"isys_cmdb_dao_category_g_power_supplier\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:6:\"ampere\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CMDB__CATG__POWER_SUPPLIER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:38:\"LC__CMDB__CATG__POWER_SUPPLIER__AMPERE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:39:\"isys_cmdb_dao_category_g_power_supplier\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:9:\"connector\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CMDB__CATG__POWER_SUPPLIER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:39:\"LC__CATG__CONNECTOR__ASSIGNED_CONNECTOR\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:6;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__FC_SWITCH','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:4:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:42:\"isys_cmdb_dao_category_g_controller_fcport\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:6:\"target\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:18:\"LC__STORAGE_FCPORT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:38:\"LC__CMDB__CATG__NETWORK__TARGET_OBJECT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__FILE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:2:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__HOST','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:7:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"all_ips\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:47:\"LC__CMDB__CATG__CLUSTER_SERVICE__HOST_ADDRESSES\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"primary_hostname\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATP__IP__PRIMARY_HOSTNAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:6;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__IT_SERVICE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_its_type\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:8:\"its_type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__ITS_TYPE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__CMDB__CATG__TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__KRYPTO_CARD','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_krypto_card\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"date_of_issue\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATS__KRYPTO_CARD\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__CMDB__CATS__KRYPTO_CARD__DATE_OF_ISSUE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"date\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_krypto_card\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:20:\"certgate_card_number\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATS__KRYPTO_CARD\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:49:\"LC__CMDB__CATS__KRYPTO_CARD__CERTGATE_CARD_NUMBER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_krypto_card\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"imei_number\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATS__KRYPTO_CARD\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:40:\"LC__CMDB__CATS__KRYPTO_CARD__IMEI_NUMBER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__KVM_SWITCH','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__LAYER2_NET','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:35:\"isys_cmdb_dao_category_s_layer2_net\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"vlan_id\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:26:\"LC__CMDB__CATS__LAYER2_NET\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CMDB__CATS__LAYER2_ID\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__LAYER3_NET','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:7:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:41:\"isys_cmdb_dao_category_s_net_ip_addresses\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:15:\"ip_address_link\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:32:\"LC__CMDB__CATS__NET_IP_ADDRESSES\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:23:\"LC__CMDB__IP__URL_TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_net\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:19:\"LC__CMDB__CATS__NET\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CMDB__CATS__NET__TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_net\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:19:\"address_with_suffix\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:19:\"LC__CMDB__CATS__NET\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:40:\"LC__CMDB__CATS__NET__ADDRESS_WITH_SUFFIX\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_net\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"address_range\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:19:\"LC__CMDB__CATS__NET\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:34:\"LC__CMDB__CATS__NET__ADDRESS_RANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_net\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"netmask\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:19:\"LC__CMDB__CATS__NET\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CMDB__CATS__NET__MASK\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_net\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:14:\"free_addresses\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:19:\"LC__CMDB__CATS__NET\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:31:\"LC__CMDB__CATG__NETWORK__ASS_IP\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:6;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__LICENCE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_lic\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:6:\"amount\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:28:\"LC__CMDB__CATS__LICENCE_LIST\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CMDB__CATS__LICENCE_AMOUNT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_lic\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:14:\"lic_not_in_use\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:28:\"LC__CMDB__CATS__LICENCE_LIST\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:28:\"LC__CMDB__CATS__LICENCE_FREE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_lic\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:28:\"LC__CMDB__CATS__LICENCE_LIST\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:28:\"LC__CMDB__CATS__LICENCE_TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__MAINTENANCE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_s_contract\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATS__CONTRACT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CMDB__CATS__CONTRACT__TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_s_contract\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:15:\"contract_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATS__CONTRACT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:32:\"LC__CMDB__CATS__CONTRACT__STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_s_contract\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:8:\"run_time\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATS__CONTRACT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:32:\"LC__CMDB__CATG__LEASING__RUNTIME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__MIDDLEWARE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_application\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATS__APPLICATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:27:\"LC__CMDB__CATG__MANUFACTURE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__MIGRATION_OBJECT','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:2:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__MONITOR','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__NAGIOS_HOST_TPL','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__NAGIOS_SERVICE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__NAGIOS_SERVICE_TPL','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__OPERATING_SYSTEM','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":10:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:4:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:41:\"isys_cmdb_dao_category_s_operating_system\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:32:\"LC__CMDB__CATS__OPERATING_SYSTEM\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:27:\"LC__CMDB__CATG__MANUFACTURE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:41:\"isys_cmdb_dao_category_s_operating_system\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:18:\"installation_count\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:32:\"LC__CMDB__CATS__OPERATING_SYSTEM\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:46:\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";s:38:\"isys_cmdb_dao_category_g_global__title\";s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterWildcard\";b:0;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0broadsearch\";b:0;s:65:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0advancedOptionMemoryUnit\";s:2:\"GB\";}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ORGANIZATION','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_address\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:6:\"street\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:17:\"LC__CATG__ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:32:\"LC__CONTACT__ORGANISATION_STREET\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_address\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:8:\"postcode\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:17:\"LC__CATG__ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:37:\"LC__CONTACT__ORGANISATION_POSTAL_CODE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_address\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"city\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:17:\"LC__CATG__ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CONTACT__ORGANISATION_CITY\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:44:\"isys_cmdb_dao_category_s_organization_master\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:9:\"telephone\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:40:\"LC__CMDB__CATS__ORGANIZATION_MASTER_DATA\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:31:\"LC__CONTACT__ORGANISATION_PHONE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PARALLEL_RELATION','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:2:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";N;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__UNIVERSAL__TITLE_LINK\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:42:\"isys_cmdb_dao_category_s_parallel_relation\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:9:\"threshold\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";N;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:22:\"LC__CATS__AC_THRESHOLD\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PATCH_PANEL','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PDU','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:4:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:34:\"isys_cmdb_dao_category_g_connector\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:26:\"LC__CMDB__CATG__CONNECTORS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PERSON','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:38:\"isys_cmdb_dao_category_s_person_master\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:9:\"last_name\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CONTACT__TREE__MASTER_DATA\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CONTACT__PERSON_LAST_NAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:38:\"isys_cmdb_dao_category_s_person_master\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:10:\"first_name\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CONTACT__TREE__MASTER_DATA\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CONTACT__PERSON_FIRST_NAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:38:\"isys_cmdb_dao_category_s_person_master\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:10:\"department\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CONTACT__TREE__MASTER_DATA\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CONTACT__PERSON_DEPARTMENT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:38:\"isys_cmdb_dao_category_s_person_master\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"phone_company\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CONTACT__TREE__MASTER_DATA\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:37:\"LC__CONTACT__PERSON_TELEPHONE_COMPANY\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:38:\"isys_cmdb_dao_category_s_person_master\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"mail\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CONTACT__TREE__MASTER_DATA\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:32:\"LC__CONTACT__PERSON_MAIL_ADDRESS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:37:\"isys_cmdb_dao_category_s_person_login\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__UNIVERSAL__LOGIN\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CONTACT__PERSON_USER_NAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PERSON_GROUP','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:4:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:44:\"isys_cmdb_dao_category_s_person_group_master\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"email_address\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CONTACT__TREE__MASTER_DATA\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:32:\"LC__CONTACT__GROUP_EMAIL_ADDRESS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:44:\"isys_cmdb_dao_category_s_person_group_master\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"phone\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CONTACT__TREE__MASTER_DATA\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:24:\"LC__CONTACT__GROUP_PHONE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:44:\"isys_cmdb_dao_category_s_person_group_master\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:10:\"ldap_group\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:30:\"LC__CONTACT__TREE__MASTER_DATA\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:43:\"LC__CMDB__CATS__PERSON_GROUPS__LDAP_MAPPING\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PHONE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:38:\"isys_cmdb_dao_category_g_telephone_fax\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:9:\"extension\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:29:\"LC__CMDB__CATG__TELEPHONE_FAX\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:40:\"LC__CMDB__CATG__TELEPHONE_FAX__EXTENSION\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:38:\"isys_cmdb_dao_category_g_telephone_fax\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"telephone_number\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:29:\"LC__CMDB__CATG__TELEPHONE_FAX\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:47:\"LC__CMDB__CATG__TELEPHONE_FAX__TELEPHONE_NUMBER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PRINTBOX','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__PRINTER','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_prt\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:19:\"LC__CMDB__CATS__PRT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:24:\"LC__CMDB__CATS__PRT_TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__RELATION','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_relation\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"relation_type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";N;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:33:\"LC__CATG__RELATION__RELATION_TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_relation\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:9:\"weighting\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";N;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CATG__RELATION__WEIGHTING\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_relation\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:9:\"itservice\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";N;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__CMDB__CATG__IT_SERVICE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__REPLICATION','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:4:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_replication\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:21:\"replication_mechanism\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CATS__REPLICATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:38:\"LC__CMDB__CATS__REPLICATION__MECHANISM\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:44:\"isys_cmdb_dao_category_s_replication_partner\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:19:\"replication_partner\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:29:\"LC__CATS__REPLICATION_PARTNER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CATS__REPLICATION_PARTNER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__RM_CONTROLLER','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ROOM','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:29:\"isys_cmdb_dao_category_s_room\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:6:\"number\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CMDB__CATS__ROOM\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:27:\"LC__CMDB__CATS__ROOM_NUMBER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:29:\"isys_cmdb_dao_category_s_room\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"floor\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CMDB__CATS__ROOM\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__CMDB__CATS__ROOM_FLOOR\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:29:\"isys_cmdb_dao_category_s_room\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CMDB__CATS__ROOM\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__CMDB__CATG__TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__ROUTER','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:19:\"primary_hostaddress\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CATG__IP__PRIMARY_ADDRESS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"primary_hostname\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATP__IP__PRIMARY_HOSTNAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"all_ips\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:47:\"LC__CMDB__CATG__CLUSTER_SERVICE__HOST_ADDRESSES\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SAN','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_sanpool\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"description\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATG__LDEV_SERVER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CMDB__LOGBOOK__DESCRIPTION\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:10:\"commentary\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_sanpool\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:3:\"lun\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATG__LDEV_SERVER\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:3:\"LUN\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SAN_ZONING','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:35:\"isys_cmdb_dao_category_s_san_zoning\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"members\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:26:\"LC__CMDB__CATS__SAN_ZONING\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:35:\"LC__CMDB__CATS__SAN_ZONING__MEMBERS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SERVER','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:7:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:19:\"primary_hostaddress\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CATG__IP__PRIMARY_ADDRESS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"primary_hostname\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATP__IP__PRIMARY_HOSTNAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:6;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SERVICE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:4:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_s_service\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:23:\"LC__CMDB__CATS__SERVICE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:27:\"LC__CMDB__CATG__MANUFACTURE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_s_service\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:18:\"installation_count\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:23:\"LC__CMDB__CATS__SERVICE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:46:\"LC__CMDB__CATS__APPLICATION_INSTALLATION_COUNT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SIM_CARD','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_sim_card\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATS__SIM_CARD\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__CMDB__CATG__TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_sim_card\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:15:\"assigned_mobile\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATS__SIM_CARD\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:47:\"LC__CMDB__CATS__SIM_CARD__ASSIGNED_MOBILE_PHONE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_sim_card\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"network_provider\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATS__SIM_CARD\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:44:\"LC__CMDB__CATS_CP_CONTRACT__NETWORK_PROVIDER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__STACKING','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SUPERNET','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_net\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:19:\"LC__CMDB__CATS__NET\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CMDB__CATS__NET__TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_net\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:19:\"address_with_suffix\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:19:\"LC__CMDB__CATS__NET\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:40:\"LC__CMDB__CATS__NET__ADDRESS_WITH_SUFFIX\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_net\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"address_range\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:19:\"LC__CMDB__CATS__NET\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:34:\"LC__CMDB__CATS__NET__ADDRESS_RANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_net\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"netmask\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:19:\"LC__CMDB__CATS__NET\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CMDB__CATS__NET__MASK\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SWITCH','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:7:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:19:\"primary_hostaddress\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CATG__IP__PRIMARY_ADDRESS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"primary_hostname\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATP__IP__PRIMARY_HOSTNAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:6;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__SWITCH_CHASSIS','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:37:\"isys_cmdb_dao_category_s_chassis_slot\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:29:\"LC__CMDB__CATS__CHASSIS_SLOTS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:28:\"LC__CMDB__CATG__GLOBAL_TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:37:\"isys_cmdb_dao_category_s_chassis_slot\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"assigned_devices\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:29:\"LC__CMDB__CATS__CHASSIS_SLOTS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:41:\"LC__CMDB__CATS__CHASSIS__ASSIGNED_DEVICES\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_list\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__TELEPHONE_SYSTEM','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__UPS','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_s_ups\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__OBJTYPE__UPS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CMDB__CATS__UPS__TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VEHICLE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VIRTUAL_CLIENT','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:32:\"isys_cmdb_dao_category_g_contact\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:15:\"primary_contact\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:23:\"LC__CMDB__CATG__CONTACT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CATG__CONTACT_PRIMARY\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:3:\"int\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:40:\"isys_cmdb_dao_category_g_virtual_machine\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"hosts\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:31:\"LC__CMDB__CATG__VIRTUAL_MACHINE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:35:\"LC__CMDB__CATG__VM__RUNNING_ON_HOST\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:40:\"isys_cmdb_dao_category_g_virtual_machine\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"primary\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:31:\"LC__CMDB__CATG__VIRTUAL_MACHINE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CMDB__HOST_IN_CLUSTER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:40:\"isys_cmdb_dao_category_g_virtual_machine\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:6:\"system\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:31:\"LC__CMDB__CATG__VIRTUAL_MACHINE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:37:\"LC__CMDB__CATG__VIRTUALIZATION_SYSTEM\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VIRTUAL_HOST','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:8:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:19:\"primary_hostaddress\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CATG__IP__PRIMARY_ADDRESS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"primary_hostname\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATP__IP__PRIMARY_HOSTNAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:38:\"isys_cmdb_dao_category_g_guest_systems\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"connected_object\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:29:\"LC__CMDB__CATG__GUEST_SYSTEMS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__GUEST_SYSTEMS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:12:\"manufacturer\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATG__STORAGE_MANUFACTURER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:30:\"isys_cmdb_dao_category_g_model\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:21:\"LC__CMDB__CATG__MODEL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__CATG__MODEL\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:6;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:7;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VIRTUAL_SERVER','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:6:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:19:\"primary_hostaddress\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CATG__IP__PRIMARY_ADDRESS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:27:\"isys_cmdb_dao_category_g_ip\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:16:\"primary_hostname\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:20:\"LC__CATG__IP_ADDRESS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:30:\"LC__CATP__IP__PRIMARY_HOSTNAME\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:40:\"isys_cmdb_dao_category_g_virtual_machine\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"primary\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:31:\"LC__CMDB__CATG__VIRTUAL_MACHINE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:25:\"LC__CMDB__HOST_IN_CLUSTER\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:40:\"isys_cmdb_dao_category_g_virtual_machine\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"hosts\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:31:\"LC__CMDB__CATG__VIRTUAL_MACHINE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:35:\"LC__CMDB__CATG__VM__RUNNING_ON_HOST\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:5;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VOIP_PHONE','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__VRRP','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"created\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:42:\"LC__TASK__DETAIL__WORKORDER__CREATION_DATE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:7:\"changed\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:21:\"LC__CMDB__LAST_CHANGE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__WAN','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:4:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_g_wan\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"role\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:13:\"LC__CATG__WAN\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:19:\"LC__CATG__WAN__ROLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:28:\"isys_cmdb_dao_category_g_wan\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:4:\"type\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:13:\"LC__CATG__WAN\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:19:\"LC__CATG__WAN__TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__WIRING_SYSTEM','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:3:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:36:\"isys_cmdb_dao_category_s_ws_net_type\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:27:\"LC__CMDB__CATS__WS_NET_TYPE\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:27:\"LC__CMDB__CATS__WS_NET_TYPE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:11:\"dialog_plus\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.base-object-table.config.C__OBJTYPE__WORKSTATION','O:39:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\":7:{s:51:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0properties\";a:5:{i:0;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:1;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:5:\"title\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC__UNIVERSAL__TITLE\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:1;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:37:\"isys_cmdb_dao_category_g_logical_unit\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:6:\"parent\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:28:\"LC__CMDB__CATG__LOGICAL_UNIT\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:36:\"LC__CMDB__CATG__LOGICAL_UNIT__PARENT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:2;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:46:\"isys_cmdb_dao_category_g_assigned_logical_unit\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:15:\"assigned_object\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:38:\"LC__CMDB__CATG__ASSIGNED_LOGICAL_UNITS\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:20:\"LC_UNIVERSAL__OBJECT\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:14:\"object_browser\";}i:3;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:33:\"isys_cmdb_dao_category_g_location\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:13:\"location_path\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:24:\"LC__CMDB__CATG__LOCATION\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:29:\"LC__CMDB__CATG__LOCATION_PATH\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:4:\"text\";}i:4;O:41:\"idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\":7:{s:50:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0indexed\";b:0;s:48:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0class\";s:31:\"isys_cmdb_dao_category_g_global\";s:46:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0key\";s:11:\"cmdb_status\";s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0categoryName\";s:22:\"LC__CMDB__CATG__GLOBAL\";s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0name\";s:26:\"LC__UNIVERSAL__CMDB_STATUS\";s:54:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0customCatID\";i:0;s:47:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Property\0type\";s:6:\"dialog\";}}s:56:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingProperty\";N;s:57:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0sortingDirection\";N;s:55:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterProperty\";N;s:52:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0filterValue\";N;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0rowClickable\";b:1;s:53:\"\0idoit\\Module\\Cmdb\\Model\\Ci\\Table\\Config\0groupingType\";i:1;}',1);
INSERT INTO `isys_settings` VALUES ('cmdb.cable.change-cmdb-status-on-attach','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.cable.change-cmdb-status-on-detach','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.chassis.handle-location-changes','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.connector.suffix-schema','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.csv-export.remove-object-ids','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.gui.objectlist.direct-edit-mode','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.gui.remember-cmdb-status','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.ip-list.cache-lifetime','86400',0);
INSERT INTO `isys_settings` VALUES ('cmdb.ip-list.nmap-parameter','PE',0);
INSERT INTO `isys_settings` VALUES ('cmdb.ip-list.ping-method','nmap',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.cmdb-explorer-service-browser','2500',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.connector-lists-assigned_connectors','5',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.obj-browser.objects-in-viewmode','8',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.port-lists-layer2','5',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.port-lists-vlans','5',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.port-overview-default-vlan-only','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.limits.port-overview-vlans','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.lists.field-length-limit','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.logical-location.handle-location-inheritage','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.logical-location.object-type-filter','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.object-browser.max-objects','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.object.title.cable-prefix','KABEL_DEFAULT_',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.10.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.101.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.28.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.3.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.45.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.5.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.76.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.83.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.89.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.objtype.90.auto-inventory-no','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.quickinfo.rows-per-category','15',0);
INSERT INTO `isys_settings` VALUES ('cmdb.quickpurge','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.rack.rank-detached-segment-objects','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.rack.segment-template-object-type','C__OBJTYPE__RACK_SEGMENT',0);
INSERT INTO `isys_settings` VALUES ('cmdb.rack.slot-assignment-sort-direction','asc',0);
INSERT INTO `isys_settings` VALUES ('cmdb.rack.vertical-slot-rear-mirrored','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.rack.vertical-slot-sorting','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.refresh-table-configurations','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.lock_dataset','',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.lock_timeout','120',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.mytask_entries','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.object_dragndrop','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.object_type_sorting','2',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.quicksave','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.sanitize_input_data','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.registry.sysid_readonly','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.release-ip-on-archive-delete','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.renew-properties','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.sysid.prefix','SYSID_',0);
INSERT INTO `isys_settings` VALUES ('cmdb.table.fuzzy-distance','50',0);
INSERT INTO `isys_settings` VALUES ('cmdb.table.fuzzy-suggestion','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.table.fuzzy-threshold','0.2',0);
INSERT INTO `isys_settings` VALUES ('cmdb.template.color_value','CC0000',0);
INSERT INTO `isys_settings` VALUES ('cmdb.template.colors','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.template.show_assignments','1',0);
INSERT INTO `isys_settings` VALUES ('cmdb.template.status','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.unique.hostname','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.unique.ip-address','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.unique.layer-2-net','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.unique.object-title','0',0);
INSERT INTO `isys_settings` VALUES ('cmdb.validation.mac-address','0',0);
INSERT INTO `isys_settings` VALUES ('debug_bar.storeDirectory','/tmp/idoit_debugbar',0);
INSERT INTO `isys_settings` VALUES ('debug-bar.enabled','0',0);
INSERT INTO `isys_settings` VALUES ('defaults.search.mode','1',0);
INSERT INTO `isys_settings` VALUES ('email.template.maintenance','Your maintenance contract: %s timed out.\r\n\r\n<strong>Contract information</strong>:\r\nStart: %s\r\nEnd: %s\r\nSupport-Url: %s\r\nContract-Number: %s\r\nCustomer-Number: %s',0);
INSERT INTO `isys_settings` VALUES ('email.template.password','Ihr Passwort lautet:',0);
INSERT INTO `isys_settings` VALUES ('gui.empty_value','-',0);
INSERT INTO `isys_settings` VALUES ('gui.empty_values','-',0);
INSERT INTO `isys_settings` VALUES ('gui.forum-link','0',0);
INSERT INTO `isys_settings` VALUES ('gui.leftcontent.width','',0);
INSERT INTO `isys_settings` VALUES ('gui.lists.preload-pages','30',0);
INSERT INTO `isys_settings` VALUES ('gui.location_path.direction.rtl','0',0);
INSERT INTO `isys_settings` VALUES ('gui.separator.connector',' > ',0);
INSERT INTO `isys_settings` VALUES ('gui.separator.location',' > ',0);
INSERT INTO `isys_settings` VALUES ('gui.wiki-url','',0);
INSERT INTO `isys_settings` VALUES ('gui.wysiwyg','1',0);
INSERT INTO `isys_settings` VALUES ('gui.wysiwyg-all-controls','1',0);
INSERT INTO `isys_settings` VALUES ('idoit.notifications.license-expiration.skip-expired','0',0);
INSERT INTO `isys_settings` VALUES ('import.csv.import-limit','25',0);
INSERT INTO `isys_settings` VALUES ('import.csv.overwrite-objecttype','0',0);
INSERT INTO `isys_settings` VALUES ('import.hinventory.object-matching','1',0);
INSERT INTO `isys_settings` VALUES ('import.object.keep-status','0',0);
INSERT INTO `isys_settings` VALUES ('import.validation.break-on-error','1',0);
INSERT INTO `isys_settings` VALUES ('import.validation.empty-attribute-on-error','0',0);
INSERT INTO `isys_settings` VALUES ('jdisc.threshold','0',0);
INSERT INTO `isys_settings` VALUES ('jdisc.threshold_type','days',0);
INSERT INTO `isys_settings` VALUES ('key','value',0);
INSERT INTO `isys_settings` VALUES ('ldap.config','',0);
INSERT INTO `isys_settings` VALUES ('ldap.debug','1',0);
INSERT INTO `isys_settings` VALUES ('ldap.default-group','',0);
INSERT INTO `isys_settings` VALUES ('ldap.person.salutation.man','Herr, Mr., Mr',0);
INSERT INTO `isys_settings` VALUES ('ldap.person.salutation.woman','Frau, Mrs., Mrs, Ms., Ms, Miss',0);
INSERT INTO `isys_settings` VALUES ('logbook.changes','1',0);
INSERT INTO `isys_settings` VALUES ('logbook.delete-on-object-purge','0',0);
INSERT INTO `isys_settings` VALUES ('logging.cmdb.import','1',0);
INSERT INTO `isys_settings` VALUES ('logging.system.exceptions','0',0);
INSERT INTO `isys_settings` VALUES ('logging.user.last-login','0',0);
INSERT INTO `isys_settings` VALUES ('login.tenantlist.sortby','isys_mandator__sort',0);
INSERT INTO `isys_settings` VALUES ('maxlength.dialog_plus','110',0);
INSERT INTO `isys_settings` VALUES ('maxlength.location.objects','16',0);
INSERT INTO `isys_settings` VALUES ('maxlength.location.path','100',0);
INSERT INTO `isys_settings` VALUES ('minlength.login.password','4',0);
INSERT INTO `isys_settings` VALUES ('mysql.unbuffered-queries','0',0);
INSERT INTO `isys_settings` VALUES ('proxy.active','0',0);
INSERT INTO `isys_settings` VALUES ('proxy.host','',0);
INSERT INTO `isys_settings` VALUES ('proxy.password','',0);
INSERT INTO `isys_settings` VALUES ('proxy.port','',0);
INSERT INTO `isys_settings` VALUES ('proxy.username','',0);
INSERT INTO `isys_settings` VALUES ('qrcode.config','',0);
INSERT INTO `isys_settings` VALUES ('security.passwort.minlength','',0);
INSERT INTO `isys_settings` VALUES ('session.sso.active','0',0);
INSERT INTO `isys_settings` VALUES ('session.sso.mandator-id','1',0);
INSERT INTO `isys_settings` VALUES ('session.sso.use-domain-part','0',0);
INSERT INTO `isys_settings` VALUES ('session.time','3600',0);
INSERT INTO `isys_settings` VALUES ('system.csv-export-delimiter',';',0);
INSERT INTO `isys_settings` VALUES ('system.default-language','en',0);
INSERT INTO `isys_settings` VALUES ('system.devmode','',0);
INSERT INTO `isys_settings` VALUES ('system.email.connection-timeout','',0);
INSERT INTO `isys_settings` VALUES ('system.email.from','i-doit@example-domain.int',0);
INSERT INTO `isys_settings` VALUES ('system.email.name','',0);
INSERT INTO `isys_settings` VALUES ('system.email.password','',0);
INSERT INTO `isys_settings` VALUES ('system.email.port','',0);
INSERT INTO `isys_settings` VALUES ('system.email.smtp-auto-tls','0',0);
INSERT INTO `isys_settings` VALUES ('system.email.smtp-host','',0);
INSERT INTO `isys_settings` VALUES ('system.email.smtpdebug','0',0);
INSERT INTO `isys_settings` VALUES ('system.email.subject-prefix','[i-doit] ',0);
INSERT INTO `isys_settings` VALUES ('system.email.username','',0);
INSERT INTO `isys_settings` VALUES ('system.last-change',UNIX_TIMESTAMP(),0);
INSERT INTO `isys_settings` VALUES ('system.login.welcome-message','',0);
INSERT INTO `isys_settings` VALUES ('system.security.csrf','1',0);
INSERT INTO `isys_settings` VALUES ('system.show-proc-time','0',0);
INSERT INTO `isys_settings` VALUES ('system.timezone','Europe/Berlin',0);
INSERT INTO `isys_settings` VALUES ('tts.rt.queues','',0);
