<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type IP6TransportInput
 * An IP6 transport holding the IP address, prefix length and hostnames * @property null|int $configuredPrefixLength = null The transport's configured prefix length.
 * @property null|iterable|string[] $hostnames = null The transport hostnames.
 * @property null|string $ipAddress = null The transport's IP6 address.
 * @property null|bool $isMainAddress = null A flag that indicates whether this is the device's main IP address.
 * @property null|bool $isRouting = null A flag that indicates whether this transport is routing or not.
 * @property null|IP6NetworkInputInputType $network = null The assigned network for a transport.
 */
final class IP6TransportInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'network') {
            return new IP6NetworkInputInputType($value);
        }

        return $value;
    }
}