<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ProcessorInput
 * The processor represents a processor within a processor slot on the mainboard. * @property null|int $addressWidth = null The processor address width.
 * @property null|int $currentClockSpeed = null The current clock speed at the time of the scan in Mhz
 * @property null|int $dataWidth = null The processor data width.
 * @property null|string $devID = null The processor device id.
 * @property null|int $l2CacheSize = null The processor level 2 cache size.
 * @property null|int $l2CacheSpeed = null The processor level 2 cache speed.
 * @property null|int $l3CacheSize = null The processor level 3 cache size.
 * @property null|int $l3CacheSpeed = null The processor level 3 cache speed.
 * @property null|string $manufacturer = null The processor manufacturer.
 * @property null|int $maxClockSpeed = null The maximal clock speed at the time of the scan in Mhz
 * @property null|string $model = null The processor model.
 * @property null|int $numberOfCores = null The number of cores.
 * @property null|int $numberOfEnabledCores = null The number of enabled cores. Some servers allow to disable cores.
For instance to be license compliant for software that is licensed per core.
 * @property null|int $numberOfThreads = null The number of threads.
 * @property null|string $rawModel = null The processor raw model as it comes from the BIOS information.
 * @property null|ProcessorStatusEnum $status = null The maximal clock speed at the time of the scan in Mhz
 */
final class ProcessorInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'status') {
            return new ProcessorStatusEnum($value);
        }

        return $value;
    }
}