<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ScheduledTaskInput
 * A scheduled task defined for a device * @property null|string $author = null The scheduled task author.
 * @property null|iterable|ScheduledTaskComHandlerActionInputInputType[] $comHandlerActions = null The list of scheduled task Microsoft COM handler actions.
 * @property null|string $description = null The scheduled task description.
 * @property null|DeviceInputInputType $device = null The device to which this scheduled task belongs to.
 * @property null|iterable|ScheduledTaskEmailActionInputInputType[] $emailActions = null The list of scheduled task email actions.
 * @property null|bool $enabled = null Flag whether the scheduled task is enabled.
 * @property null|iterable|ScheduledTaskExecuteActionInputInputType[] $executeActions = null The list of scheduled task execute actions.
 * @property null|bool $hidden = null Flag whether the scheduled task is hidden.
 * @property mixed $lastExecutedTime = null The timestamp when the task has been executed for the last time.
 * @property mixed $lastExecutionResult = null The last execution result.
 * @property null|DeviceScheduledTaskLogonTypeEnum $logonType = null The scheduled task logon type.
 * @property null|iterable|ScheduledTaskMessageActionInputInputType[] $messageActions = null The list of scheduled task email actions.
 * @property mixed $registrationDate = null The scheduled task registration date.
 * @property null|DeviceScheduledTaskRunLevelTypeEnum $runlevel = null The scheduled task logon type.
 * @property null|iterable|ScheduledTaskTriggerInputInputType[] $triggers = null The list of scheduled task triggers.
 * @property null|string $uri = null The URI for the scheduled task.
 * @property null|UserInputInputType $user = null The user which thise user runs as.
 * @property null|UserGroupInputInputType $userGroup = null The usergroup used to run this task.
 */
final class ScheduledTaskInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'comHandlerActions') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ScheduledTaskComHandlerActionInputInputType($v)); })($value);
        }

        if ($name === 'device') {
            return new DeviceInputInputType($value);
        }

        if ($name === 'emailActions') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ScheduledTaskEmailActionInputInputType($v)); })($value);
        }

        if ($name === 'executeActions') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ScheduledTaskExecuteActionInputInputType($v)); })($value);
        }

        if ($name === 'logonType') {
            return new DeviceScheduledTaskLogonTypeEnum($value);
        }

        if ($name === 'messageActions') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ScheduledTaskMessageActionInputInputType($v)); })($value);
        }

        if ($name === 'runlevel') {
            return new DeviceScheduledTaskRunLevelTypeEnum($value);
        }

        if ($name === 'triggers') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ScheduledTaskTriggerInputInputType($v)); })($value);
        }

        if ($name === 'user') {
            return new UserInputInputType($value);
        }

        if ($name === 'userGroup') {
            return new UserGroupInputInputType($value);
        }

        return $value;
    }
}