<?php

namespace idoit\Module\Pro\SettingPage\Center\ContractCenter;

use DateTime;
use idoit\Module\Pro\SettingPage\Center\Base;
use isys_application;
use isys_auth;
use isys_component_template_navbar;
use isys_helper_link;
use isys_module_pro as ModulePro;
use isys_module_system as ModuleSystem;

class ContractCenter extends Base
{
    /**
     * @param $navMode *
     *
     * @return void
     * @throws \isys_exception_auth
     * @throws \isys_exception_database
     */
    protected function render($navMode, $response): void
    {
        $wwwPath = rtrim(isys_application::instance()->www_path, '/');

        isys_component_template_navbar::getInstance()
            ->append_button($this->lang->get('LC__CONTRACT_CENTER__CONTACT_US'), 'contract-center-contact-us', [
                'url' => '?',
                'icon' => $wwwPath . '/images/axialis/hardware-network/phone-6.svg',
                'navmode' => 'contract-center-contact-us'
            ])
            ->append_button($this->lang->get('LC__CONTRACT_CENTER__INSTALLATION_INSTRUCTIONS'), 'contract-center-installation', [
                'url' => '?',
                'icon' => $wwwPath . '/images/axialis/web-email/external-link.svg',
                'navmode' => 'contract-center-installation'
            ])
            ->append_button($this->lang->get('LC__CONTRACT_CENTER__ACTIVATION_INSTRUCTIONS'), 'contract-center-activation', [
                'url' => '?',
                'icon' => $wwwPath . '/images/axialis/web-email/external-link.svg',
                'navmode' => 'contract-center-activation'
            ]);

        $downloadCenterUrl = isys_helper_link::create_url([
            C__GET__MODULE_ID     => C__MODULE__SYSTEM,
            C__GET__MODULE_SUB_ID => C__MODULE__PRO,
            C__GET__SETTINGS_PAGE => 'download-center'
        ], true);

        $contactUsModalUrl = isys_application::instance()->container->get('route_generator')->generate('pro.contract-center.contact-us');

        $this->tpl
            ->assign('content_title', $this->lang->get('LC__CONTRACT_CENTER'))
            ->assign('cssPath', ModulePro::getPath() . 'assets/css/contract-center.css')
            ->assign('downloadCenterUrl', $downloadCenterUrl)
            ->assign('contactUsModalUrl', $contactUsModalUrl)
            ->assign('contract', $this->processContractData($response['data']))
            ->smarty_tom_add_rule('tom.content.navbar.cRecStatus.p_bInvisible=1')
            ->include_template('contentbottomcontent', ModulePro::getPath() . 'templates/SettingPage/Center/Contract/contract-center.tpl');
    }

    /**
     * @param array $data
     *
     * @return array
     * @throws \Exception
     */
    private function processContractData(array $data): array
    {

        $data['startDate'] = $this->processDate($data['startDate']);
        $data['subscriptionEndDate'] = $this->processDate($data['subscriptionEndDate']);
        $data['endDate'] = $this->processDate($data['endDate']);

        $data['assets'] = array_filter($data['assets'], fn ($asset) => $asset['type'] !== 'addon_free');

        return $data;
    }

    /**
     * @param array|null $date
     *
     * @return string
     * @throws \Exception
     */
    private function processDate(?array $date): string
    {
        if ($date === null) {
            return '-';
        }

        return isys_application::instance()->container->get('locales')->fmt_date((new DateTime($date['date']))->getTimestamp());
    }

    protected function checkAuth(): void
    {
        ModuleSystem::getAuth()->check(isys_auth::VIEW, 'contract-center');
    }

    /**
     * @return string
     */
    protected function getUrl(): string
    {
        return '/contract';
    }
}
