<?php

namespace idoit\Module\System\SettingPage\AttributeVisibility;

use idoit\Module\Cmdb\Search\Index\Data\Source\Category\isys_cmdb_dao_category_g_ip;
use idoit\Module\Multiedit\Component\Filter\CategoryFilter;
use idoit\Module\Multiedit\Model\CustomCategories;
use idoit\Module\Multiedit\Model\GlobalCategories;
use idoit\Module\Multiedit\Model\SpecificCategories;
use idoit\Module\System\SettingPage\SettingPage;
use idoit\Module\System\Model\AttributeVisibility as Dao;
use isys_auth as Auth;
use isys_cmdb_dao_category;
use isys_component_template_navbar;
use isys_module_system as ModuleSystem;
use isys_application as App;
use isys_module_cmdb as ModuleCmdb;

class AttributeVisibility extends SettingPage
{
    public function renderPage($navMode)
    {
        if (isset($_GET[C__GET__ID]) && !empty($_GET[C__GET__ID]) && !in_array($navMode, [C__NAVMODE__EDIT, C__NAVMODE__SAVE, C__NAVMODE__CANCEL])) {
            $navMode = C__NAVMODE__EDIT;
        }
        $navBar = isys_component_template_navbar::getInstance();
        $navBar->hide_all_buttons();

        $auth = ModuleCmdb::getAuth();
        $auth->check(Auth::VIEW, 'attribute_visibility');

        switch ($navMode) {
            case C__NAVMODE__EDIT:

                $navBar
                    ->set_active(true, C__NAVBAR_BUTTON__SAVE)
                    ->set_active(true, C__NAVBAR_BUTTON__CANCEL);
                $this->tpl
                    ->activate_editmode();

                break;
            default:
                isys_component_template_navbar::getInstance()
                    ->set_active(
                        $auth->is_allowed_to(Auth::EDIT, 'attribute_visibility'),
                        C__NAVBAR_BUTTON__EDIT
                    );

                break;
        }

        $this->renderConfig();
    }

    /**
     * @return array
     * @throws \isys_exception_database
     */
    public function getCategories()
    {
        $language = App::instance()->container->get('language');
        $cmdbDao = App::instance()->container->get('cmdb_dao');
        $database = App::instance()->container->get('database');
        $globalLabel = $language->get('LC__CMDB__GLOBAL_CATEGORIES');
        $specificLabel = $language->get('LC__CMDB__SPECIFIC_CATEGORIES');
        $customLabel = $language->get('LC__CMDB__CUSTOM_CATEGORIES');
        $supportedCategoryTypes = implode(',', array_map([$cmdbDao, 'convert_sql_int'], $this->supportedCategoryTypes()));
        $specificData = $globalData = $customData = [];

        $changeKey = function ($key) {
            $class = array_pop(explode(':', $key));
            /**
             * @var isys_cmdb_dao_category $dao;
             */
            $dao = $class::instance(App::instance()->container->get('database'));
            return $dao->get_category_const();
        };

        $filter = new CategoryFilter();
        $specificCategories = SpecificCategories::instance($database);
        $specificCategoryData = $specificCategories
            ->setFilter($filter)
            ->setData()
            ->getData();

        foreach ($specificCategoryData as $key => $data) {
            $specificData[$changeKey($key)] = $data;
        }

        $globalCategories = GlobalCategories::instance($database);
        $globalCategoryData = $globalCategories
            ->setFilter($filter)
            ->setData()
            ->getData();

        foreach ($globalCategoryData as $key => $data) {
            $globalData[$changeKey($key)] = $data;
        }

        $customCategies = CustomCategories::instance($database);
        $customCategoryData = $customCategies
            ->setFilter($filter)
            ->setData()
            ->getData();

        foreach ($customCategoryData as $key => $data) {
            $customData[$changeKey($key)] = $data;
        }

        asort($globalData);
        asort($specificData);
        asort($customData);

        $data = [
            $globalLabel => $globalData,
            $specificLabel => $specificData,
            $customLabel => $customData
        ];

        return $data;
    }

    private function renderConfig()
    {
        $dao = Dao::instance(App::instance()->container->get('database'));
        $categories = $dao->getCategories();
        $config = $dao->getConfig();

        $rules = [
            'C__ATTRIBUTE_VISIBILITY__CATEGORIES' => [
                'p_arData' => $categories
            ]
        ];

        $this->tpl
            ->assign('content_title', $this->lang->get('LC__CMDB__TREE__SYSTEM__ATTRIBUTE_VISIBILITY'))
            ->assign('configuredCategories', $config)
            ->smarty_tom_add_rule('tom.content.navbar.cRecStatus.p_bInvisible=1')
            ->smarty_tom_add_rules('tom.content.bottom.content', $rules)
            ->include_template('contentbottomcontent', ModuleSystem::getPath() . 'templates/SettingPage/AttributeVisibility/config.tpl');
    }
}
