<div id="duplicate-username-check">
    <div class="modal-header">
        <h1>[{isys type="lang" ident="LC__MODULE__SYSTEM__DUPLICATE_USERNAMES__MODAL_TITLE"}]</h1>
        <button type="button" class="btn btn-secondary modal-close ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>
    <div class="modal-content p10">
        [{if $hasDuplicates}]
            <p>[{isys type="lang" ident="LC__MODULE__SYSTEM__DUPLICATE_USERNAMES__FOUND_DUPLICATES"}]</p>
            [{foreach $duplicatedData as $data}]
            <h2 class="p5 mt20">[{$data.amount}]x username "[{$data.title}]"</h2>
            <table class="border listing">
                <thead>
                    <th>[{isys type="lang" ident="LC__UNIVERSAL__OBJECT_ID"}]</th>
                    <th>[{isys type="lang" ident="LC__UNIVERSAL__OBJECT_TITLE"}]</th>
                    <th>[{isys type="lang" ident="LC__UNIVERSAL__TITLE_LINK"}]</th>
                </thead>
                <tbody>
                [{foreach $data.details as $detail}]
                    <tr>
                        <td>[{$detail.id}]</td>
                        <td>[{$detail.title}]</td>
                        <td>
                            <a href="[{$detail.link}]" class="btn" target="_blank">
                                <img src="[{$dir_images}]axialis/basic/link.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__TITLE_LINK"}]</span>
                            </a>
                        </td>
                    </tr>
                [{/foreach}]
                </tbody>
            </table>
            [{/foreach}]
        [{else}]
            <div class="display-flex align-items-center justify-content-center h100">
                <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt="" class="mr5" />
                <span class="text-green">[{isys type="lang" ident="LC__MODULE__SYSTEM__DUPLICATE_USERNAMES__NO_DUPLICATES"}]</span>
            </div>
        [{/if}]
    </div>
    <div class="modal-footer">
        <button type="button" class="btn modal-close">
            <span>[{isys type="lang" ident="LC__VISUALIZATION_PROFILES__CLOSE_POPUP"}]</span>
        </button>
    </div>
</div>

<script>
    (function () {
        'use strict';

        const $modal = $('duplicate-username-check');

        $('body').fire('update:tooltips');

        $modal.on('click', '.modal-close', function () {
            Modal.close($modal.up('.modal'));
        });
    })();
</script>
