<?php

namespace idoit\Component\PlaceholderReplacer\Placeholder\Counter;

use idoit\Component\PlaceholderReplacer\Config;

trait CounterTrait
{
    /**
     * @var array
     */
    protected static array $currentCounters = [];

    /**
     * @param string $key
     * @param int    $initialValue
     *
     * @return void
     */
    public static function updateCounter(string $key, int $initialValue = 0)
    {
        if (!isset(self::$currentCounters[$key])) {
            self::$currentCounters[$key] = $initialValue;
            return;
        }
        self::$currentCounters[$key]++;
    }

    /**
     * @param $key
     *
     * @return mixed
     */
    public static function getCounter($key)
    {
        return self::$currentCounters[$key] ?? null;
    }

    /**
     * @param string|null $key
     *
     * @return array|mixed
     */
    public static function getCurrentCounters(?string $key = null)
    {
        if ($key && isset(self::$currentCounters[$key])) {
            return self::$currentCounters[$key];
        }

        return self::$currentCounters;
    }

    /**
     * @param string $value
     * @param Config $config
     *
     * @return void
     */
    public static function setCounters(string $value, Config $config)
    {
        preg_match_all(static::$pattern, $value, $matches);

        foreach ($matches[0] as $search) {
            if (isset(self::$currentCounters[$search])) {
                continue;
            }
            self::$currentCounters[$search] = $config->getTableInitialCount();
        }
    }
}
