<?php

/**
 * AJAX
 *
 * @package     i-doit
 * @subpackage  General
 * @author      Van Quyen Hoang <qhoang@i-doit.org>
 * @version     0.9.9-9
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       0.9.9-9
 */
class isys_ajax_handler_update_contact_primary extends isys_ajax_handler
{
    /**
     * Init method, which holds the necessary logic.
     */
    public function init()
    {
        header('Content-Type: application/json');

        $l_return = [
            'success' => true,
            'data'    => null,
            'message' => null
        ];

        try {
            $objectId = (int)$_POST[C__CMDB__GET__OBJECT];
            $entryId = (int)$_POST['id'];

            isys_auth_cmdb::instance()->check_rights_obj_and_category(isys_auth::EDIT, $objectId, 'C__CATG__CONTACT');

            $daoContact = isys_cmdb_dao_category_g_contact::instance(isys_application::instance()->container->get('database'));
            $language = isys_application::instance()->container->get('language');

            $fromContact = '';
            $toContact = '';

            $primaryContactId = $daoContact
                ->get_data(null, $objectId, ' AND isys_catg_contact_list__primary_contact = 1 ')
                ->get_row_value('isys_connection__isys_obj__id');

            if ($primaryContactId !== null) {
                $primaryContact = $daoContact->get_object($primaryContactId)->get_row();
                $fromContact = $language->get($primaryContact['isys_obj_type__title']) . ' &raquo; ' . $language->get($primaryContact['isys_obj__title']);
            }

            if (!$daoContact->is_primary($entryId)) {
                $daoContact->make_primary($objectId, $entryId);
                $l_return['data'] = ['is_primary' => true];

                $newPrimaryContactId = $daoContact
                    ->get_data($entryId)
                    ->get_row_value('isys_connection__isys_obj__id');

                if ($newPrimaryContactId !== null) {
                    $newPrimaryContact = $daoContact->get_object($newPrimaryContactId)->get_row();
                    $toContact = $language->get($newPrimaryContact['isys_obj_type__title']) . ' &raquo; ' . $language->get($newPrimaryContact['isys_obj__title']);
                }
            } else {
                $daoContact->reset_primary($objectId);
                $l_return['data'] = ['is_primary' => false];
            }

            // @see ID-9456 Record the previous and the new primary contact.
            isys_event_manager::getInstance()
                ->triggerCMDBEvent(
                    'C__LOGBOOK_EVENT__CATEGORY_CHANGED',
                    $daoContact->get_strLogbookSQL(),
                    $objectId,
                    $daoContact->get_objTypeID($objectId),
                    'LC__CMDB__CATG__CONTACT',
                    serialize([
                        'isys_cmdb_dao_category_g_contact::primary_contact' => [
                            'from' => $fromContact,
                            'to' => $toContact
                        ]
                    ])
                );
        } catch (Exception $e) {
            $l_return['success'] = false;
            $l_return['message'] = $e->getMessage();
        }

        echo isys_format_json::encode($l_return);

        $this->_die();
    }
}
