<?php

use idoit\Module\Cmdb\Controller\ImageController;
use idoit\Module\Cmdb\Controller\ObjectController;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    // CMDB object routes.
    $routes->add('cmdb.object.image', '/cmdb/object/image/{objectId}')
        ->methods(['GET'])
        ->requirements(['objectId' => '\d*'])
        ->controller([ImageController::class, 'getObjectImageById']);

    $routes->add('cmdb.object.redirect', '/cmdb/object/{objectId}')
        ->methods(['GET'])
        ->requirements(['objectId' => '\d+'])
        ->controller([ObjectController::class, 'redirectToObject']);

    $routes->add('cmdb.ajax.create-object', '/ajax/cmdb/create-object')
        ->methods(['POST'])
        ->controller([ObjectController::class, 'createObject']);

    // CMDB object type routes
    $routes->add('cmdb.object-type.image', '/cmdb/object-type/image/{objectTypeId}')
        ->methods(['GET'])
        ->requirements(['objectTypeId' => '\d*'])
        ->controller([ImageController::class, 'getObjectTypeImageById']);

    $routes->add('cmdb.object-type.image-name', '/cmdb/object-type/image/file:{filename}')
        ->methods(['GET'])
        ->requirements(['filename' => '.+\.(jpeg|jpg|png|gif|bmp|svg)'])
        ->controller([ImageController::class, 'getObjectTypeImageByFilename']);

    $routes->add('cmdb.object-type.icon', '/cmdb/object-type/icon/{objectTypeId}')
        ->methods(['GET'])
        ->requirements(['objectTypeId' => '\d*'])
        ->controller([ImageController::class, 'getObjectTypeIconById']);

    $routes->add('cmdb.object-type.icon-name', '/cmdb/object-type/icon/file:{filename}')
        ->methods(['GET'])
        ->requirements(['filename' => '.+\.(jpeg|jpg|png|gif|bmp|svg)'])
        ->controller([ImageController::class, 'getObjectTypeIconByFilename']);
};
