<?php

namespace idoit\Component\Provider;

use Symfony\Component\DependencyInjection\Container;

/**
 * i-doit Container Aware Factory Trait
 *
 * @package     i-doit
 * @subpackage  Component
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
trait DiFactory
{
    use DiInjectable;

    /**
     * Factory with $container parameter
     *
     * @param Container $container
     *
     * @return static
     */
    public static function factory(Container $container)
    {
        $instance = new self();

        if (method_exists($instance, 'setDi')) {
            $instance->setDi($container);
        }

        return $instance;
    }
}
