<?php

// Only execute this migration if it is open version
if (class_exists('isys_module_pro')) {
    return;
}

global $g_comp_database, $g_comp_database_system, $g_absdir;

// Set migrationId
$migrationIdentifier = 'migrate_pro_open_features';

// Check whether migration was executed before
if ($this->is_migration_done($migrationIdentifier)) {
    $g_migration_log[] = '<span class="bold">Migration for open features already done</span>';
} else {
    $g_migration_log[] = '<span class="bold">Migrate open features ...</span>';

    $files = [
        'src/idoit/Console/Command/Import/Csv/ImportCsvCommand.php',
        'src/idoit/Console/Command/Import/Csv/ListProfilesCommand.php',
    ];

    foreach ($files as $file) {
        $fullFileName = $g_absdir . '/' . $file;

        if (file_exists($fullFileName)) {
            unlink($fullFileName);
        }
    }

    $g_migration_log[] = '<span class="bold">Migration finished!</span>';

    $this->migration_done($migrationIdentifier);
}
