<?php

use idoit\Module\Cmdb\Controller\Category\ContactController;
use idoit\Module\Cmdb\Controller\ImageController;
use idoit\Module\Cmdb\Controller\ObjectController;
use idoit\Module\Cmdb\Controller\ValidationController;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    // CMDB object routes.
    $routes->add('cmdb.object.image', '/cmdb/object/image/{objectId}')
        ->methods(['GET'])
        ->requirements(['objectId' => '\d*'])
        ->controller([ImageController::class, 'getObjectImageById']);

    $routes->add('cmdb.object.redirect', '/cmdb/object/{objectId}')
        ->methods(['GET'])
        ->requirements(['objectId' => '\d+'])
        ->controller([ObjectController::class, 'redirectToObject']);

    $routes->add('cmdb.ajax.create-object', '/ajax/cmdb/create-object')
        ->methods(['POST'])
        ->controller([ObjectController::class, 'createObject']);

    // CMDB object type routes
    $routes->add('cmdb.object-type.image', '/cmdb/object-type/image/{objectTypeId}')
        ->methods(['GET'])
        ->requirements(['objectTypeId' => '\d*'])
        ->controller([ImageController::class, 'getObjectTypeImageById']);

    $routes->add('cmdb.object-type.image-name', '/cmdb/object-type/image/file:{filename}')
        ->methods(['GET'])
        ->requirements(['filename' => '.+\.(jpeg|jpg|png|gif|bmp|svg)'])
        ->controller([ImageController::class, 'getObjectTypeImageByFilename']);

    $routes->add('cmdb.object-type.icon', '/cmdb/object-type/icon/{objectTypeId}')
        ->methods(['GET'])
        ->requirements(['objectTypeId' => '\d*'])
        ->controller([ImageController::class, 'getObjectTypeIconById']);

    $routes->add('cmdb.object-type.icon-name', '/cmdb/object-type/icon/file:{filename}')
        ->methods(['GET'])
        ->requirements(['filename' => '.+\.(jpeg|jpg|png|gif|bmp|svg)'])
        ->controller([ImageController::class, 'getObjectTypeIconByFilename']);

    $routes->add('cmdb.category.contact.change-role', '/cmdb/category/contact/change-role')
        ->methods(['POST'])
        ->controller([ContactController::class, 'changeRole']);

    $routes->add('cmdb.category.contact.change-primary', '/cmdb/category/contact/change-primary')
        ->methods(['POST'])
        ->controller([ContactController::class, 'changePrimary']);

    // @see ID-9755 New route for new validation structure
    $routes->add('cmdb.validate.category-attribute-value', '/cmdb/validate/category-attribute-value')
        ->methods(['POST'])
        ->controller([ValidationController::class, 'validateValue']);
};
