<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type ClusterDeletionProgressInfo
 * This object contains information about the background task deleteClusters within the clusterManagement interface.
Deleting clusters can be a lengthly operation and the async version can delete the clusters in the background.
This object can be used to track the progress and hold the result of the operation. */
final class ClusterDeletionProgressInfoType implements AutoGenerationInterface, ProgressInfoInterface
{
    /**
     * The current action being performed. Can be empty or null.
     */
    public ?string $action = null;
    /**
     * A message that describes the completion status once the task is completed or canceled.
     */
    public ?string $completionMessage = null;
    /**
     * The current value for the operation's progress. Together with the maxValue, you can calculate the percentage.
     */
    public ?int $currentValue = null;
    /**
     * The error object. The error object type depends on the type of action.
     */
    public $errorObject = null;
    /**
     * Is the task failed?
     */
    public bool $hasFailed;
    /**
     * The instanceId identifies a specific operation. Use this instanceId to poll the current status.
     */
    public ?string $instanceId = null;
    /**
     * Is the task finished?
     */
    public bool $isFinished;
    /**
     * The maximum value for the operation's progress. A max value < 0 indicates, that the maximum value is not known for this operation.
     */
    public ?int $maxValue = null;
    /**
     * The result if there is one.
     */
    public $resultObject = null;
    /**
     * The exception stack trace if there is a server exception.
     */
    public ?string $stackTrace = null;
    /**
     * The current sub-action being performed. Can be empty or null.
     */
    public ?string $subAction = null;
    /**
     * When the operation completed, this property holds the list of clusters which could not be found during the deletion process.
     * @var null|iterable
     */
    public ?iterable $notFoundClusters = null;
}