<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type Devices
 * This type provides device related queries */
final class DevicesType implements AutoGenerationInterface
{
    /**
     * Find all devices
     * @var null|iterable
     */
    public ?iterable $findAll = null;
    /**
     * Find devices by id
     */
    public ?DeviceType $findByID = null;
    /**
     * Find devices by id
     * @var null|iterable
     */
    public ?iterable $findByIds = null;
    /**
     * Find devices by an integration id and a foreignId. Integrations are being used when import JDisc Discovery data into other solutions like CMDB solutions
     * @var null|iterable
     */
    public ?iterable $findByIntegrationIdAndForeignKey = null;
    /**
     * Find devices by name. The default for caseSenstitive is TRUE.
     * @var null|iterable
     */
    public ?iterable $findByName = null;
    /**
     * Find devices by operating system family
     * @var null|iterable
     */
    public ?iterable $findByOperatingSystemFamily = null;
    /**
     * Find devices by operating system version
     * @var null|iterable
     */
    public ?iterable $findByOperatingSystemVersion = null;
    /**
     * Find devices by its role
     * @var null|iterable
     */
    public ?iterable $findByRole = null;
    /**
     * Find devices by type
     * @var null|iterable
     */
    public ?iterable $findByType = null;
    /**
     * Finds all devices where type matches one of the types passed as argument.
     * @var null|iterable
     */
    public ?iterable $findByTypes = null;
    /**
     * Finds all devices with an IP address.
The activeOnly indicates whether to search only for IP addresses on active interfaces.
When the activeOnly is FALSE, then we are also looking on interfaces with a status other than 'up'.
The default for the activeOnly is TRUE
     * @var null|iterable
     */
    public ?iterable $findDevicesByIPAddress = null;
    /**
     * Find devices that are part of an IP4 network. Note: A device can be part of multiple networks!
     * @var null|iterable
     */
    public ?iterable $findDevicesInIP4Network = null;
    /**
     * Find devices that are part of an IP6 network. Note: A device can be part of multiple networks!
     * @var null|iterable
     */
    public ?iterable $findDevicesInIP6Network = null;
    /**
     * Find devices with a physical address (mac address or WWN).
     * @var null|iterable
     */
    public ?iterable $findDevicesWithPhysicalAddress = null;
    /**
     * Find devices with operating system family 'Windows' and not a server OS (osVersion contains 'Server')
     * @var null|iterable
     */
    public ?iterable $findWindowsClients = null;
    /**
     * Find devices with operating system family 'Windows' and a server OS (osVersion contains 'Server')
     * @var null|iterable
     */
    public ?iterable $findWindowsServers = null;
}