<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type NetworkInterfaceInput
 * A network interface * @property null|InterfaceStatusEnum $administrativeStatus = null The network interface's administrative status
 * @property null|string $annotation = null The network interface's annotation (often configured manually by the admins).
 * @property null|string $description = null The network interface's description.
 * @property null|DeviceInputInputType $device = null The owning device
 * @property null|IP4DHCPConfigurationInputInputType $dhcpConfig = null The DHCP configuration (if it exists).
 * @property null|bool $dhcpEnabled = null A flag whether this network interface has DHCP enabled or not
 * @property null|iterable|string[] $dnsSearchSuffixes = null The DNS suffix search order.
 * @property null|iterable|IPDnsServerConfigurationInputInputType[] $dnsServers = null The list of DNS Server configs (ordered by the index of definition).
 * @property null|string $dnsSuffix = null The DNS suffix configured for this network interface
 * @property null|DuplexModeEnum $duplexMode = null The network interface's duplex mode
 * @property null|string $extendedDescription = null The network interface's extended description.
 * @property null|int $index = null The network interface's physical address (MAC or WWN).
 * @property null|iterable|IP4TransportInputInputType[] $ip4Transports = null The list of ip4 transports including their configuration (subnet mask, hostnames).
 * @property null|iterable|IP6TransportInputInputType[] $ip6Transports = null The list of ip6 transports including their configuration (network prefix, hostnames).
 * @property null|int $mtu = null The network interface's MTU configuration.
 * @property null|InterfaceStatusEnum $operationalStatus = null The network interface's operational status
 * @property null|string $physicalAddress = null The network interface's physical address (MAC or WWN).
 * @property null|int $portId = null The network interface's port id.
 * @property mixed $speed = null The network interface's speed in Bits per second.
 * @property null|InterfaceTypeEnum $type = null The network interface's type
 * @property null|bool $useForIdentification = null A flag that indicates whether this mac address should be used to identify devices. Note that not all mac addresses can be used. For instance VPN mac addresses are often the same on ALL VPN clients!
 * @property null|iterable|NetworkInterfaceInputInputType[] $connectedNetworkInterfaces = null The list of network interfaces physically connected to this interface.
Note that there might be more than one interface in cases where you have non-managed
switches conneting devices
 * @property null|iterable|TopologyConnectionInputInputType[] $topologyConnections = null The list of topology connections for this interface.
Note that there might be more than one interface in cases where you have non-managed
switches conneting devices
 */
final class NetworkInterfaceInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'administrativeStatus') {
            return new InterfaceStatusEnum($value);
        }

        if ($name === 'device') {
            return new DeviceInputInputType($value);
        }

        if ($name === 'dhcpConfig') {
            return new IP4DHCPConfigurationInputInputType($value);
        }

        if ($name === 'dnsServers') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IPDnsServerConfigurationInputInputType($v)); })($value);
        }

        if ($name === 'duplexMode') {
            return new DuplexModeEnum($value);
        }

        if ($name === 'ip4Transports') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IP4TransportInputInputType($v)); })($value);
        }

        if ($name === 'ip6Transports') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IP6TransportInputInputType($v)); })($value);
        }

        if ($name === 'operationalStatus') {
            return new InterfaceStatusEnum($value);
        }

        if ($name === 'type') {
            return new InterfaceTypeEnum($value);
        }

        if ($name === 'connectedNetworkInterfaces') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new NetworkInterfaceInputInputType($v)); })($value);
        }

        if ($name === 'topologyConnections') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new TopologyConnectionInputInputType($v)); })($value);
        }

        return $value;
    }
}