<?php

namespace idoit\Module\JDisc\Upload;

use isys_format_json as JSON;
use isys_jdisc_dao;
use isys_module_jdisc;

class JDiscProfiles
{
    /**
     * Method for processing the custom JDisc profiles import.
     *
     * @param string $filePath
     *
     * @return array
     * @throws \idoit\Exception\JsonException
     * @throws \isys_exception_dao
     * @throws \isys_exception_database
     */
    public static function processUpload(string $filePath)
    {
        $jdisc = new isys_module_jdisc();
        $log = [];

        // Read the language data.
        $profilesData = JSON::decode(file_get_contents($filePath));
        $log[] = 'Processing data';

        foreach ($profilesData as $key => $value) {
            $last_id = null;
            $log[] = 'Import profile ' . $value;
            $profileData = $value[isys_jdisc_dao::C__PROFILES];
            $assignedObjectTypes = $value[isys_jdisc_dao::C__OBJECT_TYPE_ASSIGNMENTS];

            $objectMatching = $value[isys_module_jdisc::C__EXPORT_MATCHING_PROFILE] ?? null;
            if (!empty($profileData['object_matching'])) {
                unset($profileData['object_matching']);
            }

            if ($_GET['merge']) {
                $profile = $jdisc->getProfileByName($profileData['title']);
                if ($profile) {
                    $log[] = 'Profile exist. Updating....';
                    $last_id = $jdisc->updateRawProfileData($profile['isys_jdisc_profile__id'], $profileData);

                    if (!$last_id) {
                        $log[] = "Profile could not be updated!";
                    } else {
                        $last_id = $profile['isys_jdisc_profile__id'];
                        $log[] = 'Profile ' . $profileData['title'] . ' updated';
                    }
                } else {
                    $log[] = 'Creating new profile!';
                    $last_id = $jdisc->saveRawProfileData($profileData);

                    if ($last_id == false) {
                        $log[] = "Profile could not be created!";
                    } else {
                        $log[] = 'Profile ' . $profileData['title'] . ' created';
                    }
                }
            } else {
                $i = 0;
                $title = $profileData['title'];
                do {
                    $profile = $jdisc->getProfileByName($profileData['title']);

                    if ($profile) {
                        $i++;
                        $log[] = 'Profile with current name exist. Set name index to ' . $i;
                        $profileData['title'] = $title . "(" . $i . ")";
                    }
                } while ($profile);

                if ($i) {
                    $log[] = "New profiles name = " . $profileData['title'];
                }

                $log[] = 'Creating new profile!';
                $last_id = $jdisc->saveRawProfileData($profileData);
                $log[] = 'Profile ' . $profileData['title'] . ' created';
            }

            if (isset($last_id)) {
                $jdisc->assignObjectTypes($last_id, $assignedObjectTypes, $objectMatching);
            }
        }

        $log[] = 'All done!';

        unlink($filePath);

        return $log;
    }
}
