
[{if isset($g_list)}]
	[{$g_list}]
[{else}]

    <h3 class="p5 pt10 pb10 bg-neutral-200 border-bottom">[{isys type="lang" ident="LC__MODULE__LDAP__LDAP_CONNECTION_FOR_LOOKUPS"}]</h3>
<input type="hidden" name="id" value="[{$entryID}]">

    <table class="contentTable">
        <tr>
            <td class="key">[{isys type="lang" ident="LC_WORKFLOW__ACTIVE"}]</td>
            <td class="value">[{isys type="f_dialog" p_bDbFieldNN="1" name="C__MODULE__LDAP__ACTIVE"}]</td>
        </tr>
        <tr>
            <td class="key">Directory<span class="text-red">*</span></td>
            <td class="value">[{isys type="f_dialog" name="C__MODULE__LDAP__DIRECTORY" id="C__MODULE__LDAP__DIRECTORY" p_strTable="isys_ldap_directory"}]</td>
        </tr>
        <tr>
            <td class="key">LDAP-Version</td>
            <td class="value">[{isys type="f_dialog" p_bDbFieldNN="1" name="C__MODULE__LDAP__VERSION"}]</td>
        </tr>
        <tr>
            <td class="key">Enable LDAP Paging</td>
            <td class="value">[{isys type="f_dialog" p_bDbFieldNN="1" name="C__MODULE__LDAP__ENABLE_PAGING"}]</td>
        </tr>
        <tr>
            <td class="key">LDAP Page Limit</td>
            <td class="value">[{isys type="f_text" name="C__MODULE__LDAP__PAGE_LIMIT"}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="IP / Hostname"}]<span class="text-red">*</span></td>
            <td class="value">[{isys type="f_text" name="C__MODULE__LDAP__HOST"}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="Port"}]<span class="text-red">*</span></td>
            <td class="value">[{isys type="f_text" name="C__MODULE__LDAP__PORT"}] <img src="[{$dir_images}]axialis/basic/button-info.svg" class="vam ml10" /> <em class="text-neutral-400">default: 389</em></td>
        </tr>
        <tr>
            <td class="key">TLS</td>
            <td class="value">[{isys type="f_dialog" name="C__MODULE__LDAP__TLS"}]</td>
        </tr>
        <tr>
            <td class="key">Admin [{isys type="lang" ident="LC__LOGIN__USERNAME"}] (DN)<span class="text-red">*</span></td>
            <td class="value">[{isys type="f_text" name="C__MODULE__LDAP__DN"}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="LC__LOGIN__PASSWORD"}]<span class="text-red">*</span></td>
            <td class="value">[{isys type="f_password" name="C__MODULE__LDAP__PASS"}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="LC__MODULE__LDAP__USE_ADMIN_ONLY"}]</td>
            <td class="value pl20">
                <label class="vam">
                    <input type="checkbox" name="C__MODULE__LDAP__USE_ADMIN_ONLY" [{if !$isEditMode}]disabled[{/if}] [{if $g_use_admin_only}]checked="checked" [{/if}] value="1"/>
                    [{isys type="lang" ident="LC__UNIVERSAL__ACTIVE"}]
                </label>
            </td>
        </tr>
        <tr>
            <td class="key">Timelimit</td>
            <td class="value">[{isys type="f_text" name="C__MODULE__LDAP__TIMELIMIT"}] <img src="[{$dir_images}]axialis/basic/button-info.svg" class="vam ml10" /> <em class="text-neutral-400">default: 30</em></td>
        </tr>
    </table>

    <h3 class="p5 pt10 pb10 bg-neutral-200 border-top border-bottom">[{isys type="lang" ident="LC__MODULE__LDAP__LDAP_PARAMETER_FOR_IDOIT_LOGIN"}]</h3>
    <table class="contentTable">
        <tr>
            <td class="key">[{isys type="lang" ident="LC__LDAP__UNIQUE_IDENTIFIER"}]</td>
            <td class="value">[{isys type="f_dialog" name="C__MODULE__LDAP__UNIQUE_ATTRIBUTE"}]</td>
        </tr>
        <tr>
            <td class="key">Filter</td>
            <td class="value">[{isys type="f_text" p_strTitle="Default: (objectClass=user)" name="C__MODULE__LDAP__FILTER"}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="LC__LDAP__SEARCH_FOR_USERS_IN"}]<span class="text-red">*</span></td>
            <td class="value">
                [{isys type="f_text" name="C__MODULE__LDAP__SEARCH"}]
            </td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="LC__LDAP__RECURSIVE_SEARCH"}]</td>
            <td class="value pl20">
                <label class="vam">
                    <input type="checkbox" name="C__MODULE__LDAP__RECURSIVE" [{if !$isEditMode}]disabled[{/if}] [{if $g_recursive}]checked="checked" [{/if}] value="1"/>
                    [{isys type="lang" ident="LC__UNIVERSAL__ACTIVE"}]
                </label>
            </td>
        </tr>
        [{if $isEditMode}]
        <tr>
            <td class="vat">
                <button type="button" class="btn ml10 mt15" onclick="window.add_filter('');">
                    <img src="[{$dir_images}]axialis/basic/symbol-add.svg" alt="" /><span>[{isys type="lang" ident="LC__LDAP__ADD_FILTER"}]</span>
                </button>
                <input type="hidden" name="counter" id="counter" value="0">
            </td>
        </tr>
        [{/if}]
        <tbody id="extra_filter" class="p5 m10"></tbody>
    </table>

    <div id="openldap_only" style="display:none">
        <h3 class="p5 pt10 pb10 bg-neutral-200 border-top border-bottom">[{isys type="lang" ident="LC__MODULE__LDAP__OPENLDAP_GROUPSEARCH"}]</h3>
        <table class="contentTable">
            <tr>
                <td class="key">[{isys type="lang" ident="LC__LDAP__SEARCH_FOR_GROUPS_IN"}]<span class="text-red">*</span></td>
                <td class="value">
                    [{isys type="f_text" name="C__MODULE__LDAP__SEARCH_GROUP"}]
                </td>
            </tr>
        </table>
    </div>

	[{if $isEditMode}]
        <h3 class="p5 pt10 pb10 bg-neutral-200 border-top border-bottom">Connection-Test</h3>
		<p class="m10">
			<button type="button" id="ldap-connection-test" class="btn mr10">
                <img src="[{$dir_images}]axialis/basic/link.svg" alt="" /><span>Start Test</span>
            </button>

			<label>
				Debug-Level
				<select name="debugLevel" id="debugLevel" class="input input-mini">
					<option value="0" selected="selected">normal</option>
					<option value="6">low</option>
					<option value="7">high</option>
				</select> <img class="vam" src="[{$dir_images}]axialis/basic/button-info.svg" title="Additional debug messages are written to apache error log." />
			</label>
		</p>

		<div id="ajax_return" class="m5 p5" style="display:none;"></div>
	[{/if}]

	<script type="text/javascript">
		"use strict";
		// @see  ID-8047  Introduce a 'filter char replacement' map.
        const filterCharReplacements = JSON.parse('[{$filterCharReplacements|json_encode|escape:"javascript"}]');
		const options_types = [
				{title: 'AND', value:'&'},
				{title: 'OR', value:'|'}
			];
		const options_operators = [
				{title: '=', value:'='},
				{title: '!=', value:'!='},
				{title: '>=', value:'>='},
				{title: '<=', value:'<='}
			];
		const $filter_table = $('extra_filter');
		const $connection_test = $('ldap-connection-test');
		const $connection_result = $('ajax_return');
        const $filterAddAsNewTerm = '[{isys_module_ldap::FILTER_ADD_AS_NEW_TERM}]';
        const $filterAddAsNewFilter = '[{isys_module_ldap::FILTER_ADD_AS_NEW_FILTER}]';
        const $filterAddToLastFilter = '[{isys_module_ldap::FILTER_ADD_TO_LAST_FILTER}]';

		if ($connection_test) {
			$connection_test.on('click', function () {
				$connection_test.disable()
					.down('img').addClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg')
					.next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

				$connection_result.update('...');

				new Ajax.Submit('index.php?moduleID=[{$smarty.const.C__MODULE__LDAP}]&pID=server&id=[{$entryID}]&connection_test=1&debug=' + $F('debugLevel'),
					'ajax_return',
					'isys_form',
					{
						onComplete: function () {
							$connection_test.enable()
								.down('img').removeClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/basic/link.svg')
								.next('span').update('Start Test');

							$connection_result.show().highlight();
						}
					});
			});
		}

		if ($('C__MODULE__LDAP__DIRECTORY')) {
			$('C__MODULE__LDAP__DIRECTORY').on('change', function() {
				if (this.options[this.selectedIndex].innerHTML.trim() == 'Open LDAP') {
					$('openldap_only').show();
				} else {
					$('openldap_only').hide();
				}
			});
		}

		if ($('C__MODULE__LDAP__ENABLE_PAGING')) {
            $('C__MODULE__LDAP__ENABLE_PAGING').on('change', function (){
                if (this.getValue() > 0) {
                    $('C__MODULE__LDAP__PAGE_LIMIT').disabled = false;
                } else{
                    $('C__MODULE__LDAP__PAGE_LIMIT').disabled = true;
                }
            });
            $('C__MODULE__LDAP__ENABLE_PAGING').simulate('change');
        }

		window.add_filter = function(p_title, p_value, p_type, p_link_type, p_operator) {
            var i;

            // @see  ID-8047  Revert the replacement for the GUI.
            for (i in filterCharReplacements) {
                if (!filterCharReplacements.hasOwnProperty(i) || !p_value) {
                    continue;
                }

                p_value = p_value.replace(i, filterCharReplacements[i]);
            }

			var counter = $F('counter'),
				custom_title = new Element('input', {type:'text', name:'field_title[' + counter + ']', placeholder:'[{isys type="lang" ident="LC__LDAP__FILTER__ATTRIBUTE"}]', className:'ml5 mr15 input input-mini', value:p_title}),
				custom_value = new Element('input', {type:'text', name:'field_value[' + counter + ']', placeholder:'[{isys type="lang" ident="LC__LDAP__FILTER__VALUE"}]', className:'ml5 mr15 input input-mini', value:(p_value !== undefined)? p_value: ''}),
				custom_select = new Element('select', {name:'field_link_type[' + counter + ']', className:'input input-small'}),
				custom_select2 = new Element('select', {name:'field_operator[' + counter + ']', className:'input input-mini'});

			$('counter').setValue(parseInt(counter) + 1);
			if (Object.isUndefined(p_title)) p_title = '';
			if (Object.isUndefined(p_value)) p_value = '';

			options_types.each(function(el) {
				var option = new Element('option', {value:el.value}).update(el.title);

				if (p_link_type == el.value) {
					option.selected = true;
				}

				custom_select.insert(option);
			});

			options_operators.each(function (el) {
				var option = new Element('option', {value:el.value}).update(el.title);

				if (p_operator == el.value) {
					option.selected = true;
				}

				custom_select2.insert(option);
			});

			var l_insert = new Element('tr', {id: 'extra_filter_' + counter}).update(
				new Element('td', {className: 'm10', colspan: 2}).update(
					new Element('table', {className: 'ml20'}).update(
						new Element('tr')
							.update(new Element('td').update(new Element('label').update(new Element('span', {className:'counter'}).update()).insert(custom_title)))
							.insert(new Element('td').update(custom_select2))
							.insert(new Element('td').update(new Element('label').insert(custom_value)))
							.insert(
								new Element('td').update(
									new Element('label')
										.update('[{isys type="lang" ident="LC__LDAP__FILTER__ATTACH_TO_LAST_FILTER"}]')
										.insert(new Element('input', {type:'radio', className:'ml5 vam mr15', name:'field_type[' + counter + ']', value:$filterAddToLastFilter, checked:(p_type == $filterAddToLastFilter)}))
								)
							)
							.insert(
								new Element('td').update(
									new Element('label')
										.update('[{isys type="lang" ident="LC__LDAP__FILTER__ATTACH_NEW_FILTER"}]')
										.insert(new Element('input', {type:'radio', className:'ml5 vam mr15', name:'field_type[' + counter + ']', value:$filterAddAsNewFilter, checked:(p_type == $filterAddAsNewFilter)}))
								)
							)
							.insert(
								new Element('td')
									.update(new Element('label').update('[{isys type="lang" ident="LC__LDAP__FILTER__ADD_NEW_FILTER"}]')
									.insert(new Element('input', {type:'radio', className:'ml5 vam mr15', name:'field_type[' + counter + ']', value:$filterAddAsNewTerm, checked:(p_type == $filterAddAsNewTerm)}))
								)
							)
							.insert(new Element('td').update(custom_select))
					)
				)
			);

			if (! (p_title == "objectClass" && p_value == "user")) {
				l_insert.down('table tr').insert(
					new Element('td').update(
						new Element('button', {type: 'button', className: 'ml20 btn', onClick: 'del_filter(' + counter + ')'}).update(
								new Element('img', {className: 'mr5', src: '[{$dir_images}]axialis/basic/symbol-cancel.svg'})
							).insert(
								new Element('span').update('[{isys type="lang" ident="LC__UNIVERSAL__REMOVE"}]')
							)
					)
				);
			}

			$filter_table.insert(l_insert);

			update_filter_count();
		};

		window.del_filter = function(p_id) {
			$('extra_filter_' + p_id).remove();

			update_filter_count();
		};

		if ($('C__MODULE__LDAP__DIRECTORY')) {
            $('C__MODULE__LDAP__DIRECTORY').simulate('change');
		}

        /**
         * Set port based on encoding
         *
         * @author Selcuk Kekec <skekec@i-doit.com>
         */
        window.setPortByEncoding = function() {
            // Preparation
            var $portField = $('C__MODULE__LDAP__PORT');
            var port = 0;

            // Check encoding type
            switch ($('C__MODULE__LDAP__TLS').getValue()) {
                case '[{idoit\Module\Ldap\Helper\LdapUrlGenerator::LDAP_ENCODING_OFF}]':
                case '[{idoit\Module\Ldap\Helper\LdapUrlGenerator::LDAP_ENCODING_STARTTLS}]':
                    port = '[{idoit\Module\Ldap\Helper\LdapUrlGenerator::LDAP_DEFAULT_PORT}]';
                    break;
                case '[{idoit\Module\Ldap\Helper\LdapUrlGenerator::LDAP_ENCODING_TLS}]':
                    port = '[{idoit\Module\Ldap\Helper\LdapUrlGenerator::LDAP_TLS_PORT}]';
            }

            // Set port
            $portField.setValue(port);
        };


		function update_filter_count () {
			var counter = 0;
			$filter_table.select('span.counter').each(function($span) {
				$span.update(++counter + ') ');
			});
		}

        [{if $isEditMode && is_array($filter_arr) && count($filter_arr) > 0}]
        [{foreach $filter_arr.attributes as $filter_key => $filter_item}]
        window.add_filter(
            '[{$filter_arr.attributes[$filter_key]}]',
            '[{$filter_arr.values[$filter_key]|escape:"javascript"}]',
            '[{$filter_arr.field_type[$filter_key]}]',
            '[{$filter_arr.field_link_type[$filter_key]}]',
            '[{$filter_arr.field_operator[$filter_key]}]'
        );
        [{/foreach}]
        [{/if}]
	</script>
[{/if}]
