<?php

namespace idoit\Api\Parameter;

abstract class Parameter
{
    public const TYPE_STRING = 'string';
    public const TYPE_INTEGER = 'integer';
    public const TYPE_ARRAY = 'array';
    public const TYPE_BOOLEAN = 'boolean';

    private string $name;

    private string $type;

    private string $description;

    private $validation;

    public function __construct(string $name, string $type, ?string $description = null, ?callable $validation = null)
    {
        $this->name = $name;
        $this->type = $type;
        $this->description = $description;
        $this->validation = $validation;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function getValidation(): ?callable
    {
        return $this->validation;
    }
}
