<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type DirectoryInput
 * A directory object * @property null|string $canonicalName = null The directory canonical name.
 * @property null|iterable|DirectoryInputInputType[] $children = null The child directories.
 * @property null|iterable|ComputerAccountInputInputType[] $computerAccounts = null The computer accounts associated with the directory.
 * @property mixed $discoveryTime = null The last discovery timestamp. This is the timestamp when devices of this directory item has been scanned for the last time.
 * @property null|string $distinguishedName = null The directory distinguished name.
 * @property null|string $guid = null The directory guid.
 * @property null|string $name = null The directory name.
 * @property null|string $netBiosName = null The directory netbios name.
 * @property null|int $numberOfComputerMembers = null The number of computer members.
 * @property null|DirectoryInputInputType $parentDirectory = null The parent directory.
 * @property null|DirectoryTypeEnum $type = null The directory type.
 * @property null|string $uniqueId = null The directory unique id.
 * @property null|iterable|UserInputInputType[] $users = null The list of users assigned to this directory object.
 */
final class DirectoryInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'children') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DirectoryInputInputType($v)); })($value);
        }

        if ($name === 'computerAccounts') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ComputerAccountInputInputType($v)); })($value);
        }

        if ($name === 'parentDirectory') {
            return new DirectoryInputInputType($value);
        }

        if ($name === 'type') {
            return new DirectoryTypeEnum($value);
        }

        if ($name === 'users') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new UserInputInputType($v)); })($value);
        }

        return $value;
    }
}