<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type IP4NetworkInput
 * An IP4 network object holding the IP base address, subnet mask and the name * @property null|iterable|DeviceInputInputType[] $devices = null The list of devices belonging to this nework.
 * @property null|string $firstAddress = null A network's first IP address.
 * @property null|string $lastAddress = null A network's last IP4 address.
 * @property null|string $name = null A network's name.
 * @property null|bool $nameManuallyConfigured = null A flag that indicates whether the network's name has been configured manually or whether it has been discovered (e.g. via AD).
 * @property null|string $networkBaseAddress = null The network base address.
 * @property null|IP4NetworkInputInputType $parentNetwork = null A network's parent network (if it exists).
 * @property null|string $subnetMask = null The network subnet mask.
 * @property null|iterable|IP4TransportInputInputType[] $transports = null The list of IP4 transports associated with this network.
 */
final class IP4NetworkInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'devices') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'parentNetwork') {
            return new IP4NetworkInputInputType($value);
        }

        if ($name === 'transports') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IP4TransportInputInputType($v)); })($value);
        }

        return $value;
    }
}