<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type SnmpV3AccountInput
 * An account object for the SNMPv3 protocol containing login, password, auth type, priv type, priv password and comment. The password is for security reasons write-only. * @property null|SnmpV3AuthProtocolEnum $authProtocol = null The account's authentication protocol.
 * @property null|string $comment = null The account's comment string.
 * @property null|string $login = null The account's login name.
 * @property null|string $password = null The account's password. IMPORTANT: This field is never populated when being read from the database. This field is only used when setting passwords from the UI
 * @property null|string $privPassword = null The account's encryption password. IMPORTANT: This field is never populated when being read from the database. This field is only used when setting passwords from the UI
 * @property null|SnmpV3PrivProtocolEnum $privProtocol = null The account's privacy/encryption protocol.
 */
final class SnmpV3AccountInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'authProtocol') {
            return new SnmpV3AuthProtocolEnum($value);
        }

        if ($name === 'privProtocol') {
            return new SnmpV3PrivProtocolEnum($value);
        }

        return $value;
    }
}