<?php

namespace idoit\Module\JDisc\Graphql\Type;

abstract class AbstractType
{
    /**
     * @var string
     */
    private $key;

    /**
     * @var string|null
     */
    private $value;

    /**
     * @return string
     */
    abstract public static function getType(): string;

    /**
     * @return mixed|null
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param mixed $value
     */
    public function setValue($value): void
    {
        $this->value = $value;
    }

    /**
     * @return mixed
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @param mixed $key
     */
    public function setKey($key): void
    {
        $this->key = $key;
    }

    /**
     * @param $key
     * @param $value
     */
    public function __construct($key, $value = null)
    {
        $this->key = $key;
        $this->value = $value;
    }
}