[{isys_group name="tom.popup.attribute-settings.edit"}]
<div id="attribute-settings-popup_edit">
    <div class="popup-header-ng">
        <h1>[{$popupEditTitle}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content p20">
        <h3>[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__VISIBILITY"}]</h3>

        [{if $isUnhideable}]
        <div class="display-flex align-center mt10 mb20">
            <img src="[{$dir_images}]axialis/basic/button-info.svg" class="mr5" alt="" />
            <span>[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__CAN_NOT_BE_HIDDEN"}]</span>
        </div>
        [{/if}]

        <table [{if $isUnhideable}]class="hide"[{/if}]>
            <tr>
                <td>[{isys type="f_label" name="C__ATTRIBUTE_SETTING__HIDDEN" ident="LC__ATTRIBUTE_SETTINGS__MODE"}]</td>
                <td>[{isys type="f_dialog" name="C__ATTRIBUTE_SETTING__HIDDEN"}]</td>
            </tr>
        </table>

        <h3>[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__VALIDATION"}]</h3>

        [{if !$isViewOnly}]
        <div class="display-flex align-center mt10 mb20">
            <img src="[{$dir_images}]axialis/basic/button-info.svg" class="mr5" alt="" />
            <span>[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__CAN_NOT_BE_UNIQUE"}]</span>
        </div>
        [{/if}]

        <table [{if !$isViewOnly}]class="hide"[{/if}]>
            <tr>
                <td colspan="2">[{isys type="checkbox" name="C__ATTRIBUTE_SETTING__MANDATORY"}]</td>
            </tr>
            <tr [{if !$isMultivalued}]class="hide"[{/if}]>
                <td colspan="2">[{isys type="checkbox" name="C__ATTRIBUTE_SETTING__UNIQUE_PER_OBJECT"}]</td>
            </tr>
            <tr>
                <td colspan="2">[{isys type="checkbox" name="C__ATTRIBUTE_SETTING__UNIQUE_PER_OBJECT_TYPE"}]</td>
            </tr>
            <tr>
                <td colspan="2">[{isys type="checkbox" name="C__ATTRIBUTE_SETTING__UNIQUE_GLOBAL"}]</td>
            </tr>
        </table>

        [{if !$isValidationAllowed}]
        <div class="display-flex align-center mt10 mb20">
            <img src="[{$dir_images}]axialis/basic/button-info.svg" class="mr5" alt="" />
            <span>[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__CAN_NOT_BE_VALIDATED"}]</span>
        </div>
        [{/if}]

        <table [{if !$isValidationAllowed}]class="hide"[{/if}]>
            <tr>
                <td class="pb10">[{isys type="f_label" name="C__ATTRIBUTE_SETTING__VALIDATION" ident="LC__ATTRIBUTE_SETTINGS__EDIT_POPUP__ATTRIBUTE_NEEDS_TO_BE"}]</td>
                <td class="pb10">[{isys type="f_dialog" name="C__ATTRIBUTE_SETTING__VALIDATION"}]</td>
            </tr>
            <tr data-validation="regex">
                <td></td>
                <td>[{isys type="f_text" name="C__ATTRIBUTE_SETTING__VALIDATION_REGEX"}]</td>
            </tr>
            <tr data-validation="textfield">
                <td></td>
                <td>[{isys type="f_textarea" name="C__ATTRIBUTE_SETTING__VALIDATION_TEXTFIELD"}]</td>
            </tr>
            <tr data-validation="textfield">
                <td></td>
                <td>[{isys type="checkbox" name="C__ATTRIBUTE_SETTING__VALIDATION_TEXTFIELD_AS_DROPDOWN"}]</td>
            </tr>
        </table>
    </div>

    <div class="popup-footer">
        <button type="button" class="btn save-button">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_SAVE"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>
<script type="text/javascript">
    (function () {
        'use strict';

        const $popup = $('attribute-settings-popup_edit');
        const $saveButton = $popup.down('.save-button');

        const $hidden = $('C__ATTRIBUTE_SETTING__HIDDEN');
        const $mandatory = $('C__ATTRIBUTE_SETTING__MANDATORY');
        const $uniquePerObject = $('C__ATTRIBUTE_SETTING__UNIQUE_PER_OBJECT');
        const $uniquePerObjectType = $('C__ATTRIBUTE_SETTING__UNIQUE_PER_OBJECT_TYPE');
        const $uniqueGlobal = $('C__ATTRIBUTE_SETTING__UNIQUE_GLOBAL');
        const $validation = $('C__ATTRIBUTE_SETTING__VALIDATION');
        const $validationRegex = $('C__ATTRIBUTE_SETTING__VALIDATION_REGEX');
        const $validationTextfield = $('C__ATTRIBUTE_SETTING__VALIDATION_TEXTFIELD');
        const $validationTextfieldAsDropdown = $('C__ATTRIBUTE_SETTING__VALIDATION_TEXTFIELD_AS_DROPDOWN');

        const visibilityVisible = '[{isys_popup_attribute_setting_edit::VISIBILITY__VISIBLE}]';
        const visibilityHidden = '[{isys_popup_attribute_setting_edit::VISIBILITY__HIDDEN}]';
        const visibilityHiddenOnOverview = '[{isys_popup_attribute_setting_edit::VISIBILITY__HIDDEN_ON_OVERVIEW}]';

        $popup.on('click', '.popup-closer', function () {
            popup_close();
        });

        $validation.on('change', function () {
            $popup.select('[data-validation]').invoke('addClassName', 'hide');

            switch ($validation.getValue()) {
                default:
                    break;

                case 'FILTER_VALIDATE_REGEXP':
                    $popup.down('[data-validation="regex"]').removeClassName('hide');
                    break;

                case 'VALIDATE_BY_TEXTFIELD':
                    $popup.select('[data-validation="textfield"]').invoke('removeClassName', 'hide');
                    break;
            }
        });

        const checkRegex = () => {
            $validationRegex.removeClassName('input-error');

            try {
                new RegExp($validationRegex.getValue());
                return true;
            } catch (e) {
                $validationRegex.addClassName('input-error');
                idoit.Notify.warning('[{isys type="lang" ident="LC__SETTINGS__CMDB__VALIDATION__REGEX_SYNTAX_ERROR"}]', {life: 10})
                return false;
            }
        }

        $hidden.simulate('change');
        $validation.simulate('change');

        $saveButton.on('click', function () {
            const validationSetting = $validation.getValue();
            let validationOption = '';

            switch (validationSetting) {
                case 'FILTER_VALIDATE_REGEXP':
                    if (!checkRegex()) {
                        return;
                    }

                    validationOption = { options: { regexp: $validationRegex.getValue() } };
                    break;

                case 'VALIDATE_BY_TEXTFIELD':
                    validationOption = { value: $validationTextfield.getValue(), "as-select": $validationTextfieldAsDropdown.checked };
                    break;
            }

            $saveButton.disable()
                .down('img')
                .addClassName('animation-rotate')
                .writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg');

            new Ajax.Request('[{$editAttributeSettingUrl}]', {
                method:     'post',
                parameters: {
                    hidden: +($hidden.getValue() == visibilityHidden),
                    hiddenOverview: +($hidden.getValue() == visibilityHiddenOnOverview),
                    mandatory: +$mandatory.checked,
                    uniqueObject: +$uniquePerObject.checked,
                    uniqueObjectType: +$uniquePerObjectType.checked,
                    uniqueGlobal: +$uniqueGlobal.checked,
                    validation: validationSetting,
                    validationOption: JSON.stringify(validationOption)
                },
                onComplete: function (xhr) {
                    if (!is_json_response(xhr, true)) {
                        return;
                    }

                    const json = xhr.responseJSON;

                    if (!json.success) {
                        idoit.Notify.error(json.message, {sticky: true});

                        $saveButton.down('img')
                            .removeClassName('animation-rotate')
                            .writeAttribute('src', window.dir_images + 'axialis/basic/symbol-ok.svg');

                        return;
                    }

                    idoit.Notify.success('[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__EDIT_NOTIFICATION"}]');

                    popup_close();

                    setTimeout(function () {
                        document.location.reload();
                    }, 500);
                }
            });
        });
    })();
</script>
[{/isys_group}]
