<?php

namespace idoit\Module\Report\Configuration;

use Exception;
use SimpleXMLElement;

abstract class AbstractConfiguration
{
    const FIELDMAP_TABLE = 'table';
    const FIELDMAP_DBFIELD = 'dbField';
    const FIELDMAP_NULLABLE = 'nullable';
    const REPORT_TABLE = 'isys_report';
    const REPORT_CATEGORY_TABLE = 'isys_report_category';

    /**
     * @var SimpleXMLElement|null
     */
    private ?SimpleXMLElement $xmlElement = null;

    /**
     * @return array|string[]
     */
    public function getFieldMap()
    {
        return [
            'title' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__title',
                self::FIELDMAP_NULLABLE => false
            ],
            'description' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__description',
                self::FIELDMAP_NULLABLE => false
            ],
            'query' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__query',
                self::FIELDMAP_NULLABLE => false
            ],
            'query_row' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__query_row',
                self::FIELDMAP_NULLABLE => true
            ],
            'datetime' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__datetime',
                self::FIELDMAP_NULLABLE => false
            ],
            'last_edited' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__last_edited',
                self::FIELDMAP_NULLABLE => false
            ],
            'type' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__type',
                self::FIELDMAP_NULLABLE => false
            ],
            'user_specific' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__user_specific',
                self::FIELDMAP_NULLABLE => false
            ],
            'querybuilder_data' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__querybuilder_data',
                self::FIELDMAP_NULLABLE => false
            ],
            'empty_values' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__empty_values',
                self::FIELDMAP_NULLABLE => false
            ],
            'display_relations' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__display_relations',
                self::FIELDMAP_NULLABLE => false
            ],
            'category_report' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__category_report',
                self::FIELDMAP_NULLABLE => false
            ],
            'const' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__const',
                self::FIELDMAP_NULLABLE => true
            ],
            'compressed_multivalue_results' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__compressed_multivalue_results',
                self::FIELDMAP_NULLABLE => false
            ],
            'show_html' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__show_html',
                self::FIELDMAP_NULLABLE => false
            ],
            'keep_description_format' => [
                self::FIELDMAP_TABLE => 'isys_report',
                self::FIELDMAP_DBFIELD => 'isys_report__keep_description_format',
                self::FIELDMAP_NULLABLE => false
            ],
            'category__title' => [
                self::FIELDMAP_TABLE => 'isys_report_category',
                self::FIELDMAP_DBFIELD => 'isys_report_category__title',
                self::FIELDMAP_NULLABLE => true
            ],
            'category__const' => [
                self::FIELDMAP_TABLE => 'isys_report_category',
                self::FIELDMAP_DBFIELD => 'isys_report_category__const',
                self::FIELDMAP_NULLABLE => true
            ],
            'category__description' => [
                self::FIELDMAP_TABLE => 'isys_report_category',
                self::FIELDMAP_DBFIELD => 'isys_report_category__description',
                self::FIELDMAP_NULLABLE => true
            ],
            'category__property' => [
                self::FIELDMAP_TABLE => 'isys_report_category',
                self::FIELDMAP_DBFIELD => 'isys_report_category__property',
                self::FIELDMAP_NULLABLE => true
            ],
            'category__sort' => [
                self::FIELDMAP_TABLE => 'isys_report_category',
                self::FIELDMAP_DBFIELD => 'isys_report_category__sort',
                self::FIELDMAP_NULLABLE => true
            ],
        ];
    }

    /**
     * @return SimpleXMLElement|null
     */
    public function getXml()
    {
        return $this->xmlElement;
    }

    /**
     * @param string $xmlContent
     *
     * @return $this
     * @throws \Exception
     */
    public function setXml(string $xmlContent)
    {
        try {
            $this->xmlElement = new SimpleXMLElement($xmlContent);
        } catch (Exception $e) {
            throw ImportException::importFileIsNotValid('Invalid XML Document');
        }
        return $this;
    }
}
