<img src="[{$dir_images}]login-testimonial.svg" class="login-testimonial" />

<div class="login-container display-flex">
    <div class="login-box">
        <div class="display-flex align-items-center">
            <img class="fr" src="[{$dir_images}]logo.png" alt="i-doit" height="24" />

            <span class="ml10 mt10">
                Version: [{isys_application::instance()->info->get('version')}] [{isys_application::instance()->info->get('step')}] [{isys_application::instance()->info->get('type')}]
            </span>

            <a class="btn btn-secondary ml-auto" href="./admin/">
                <img class="fr" src="[{$dir_images}]axialis/basic/gear.svg" alt="" /><span>Admin-Center</span>
            </a>
        </div>

        <div id="ajax-loading" class="display-flex align-items-center justify-content-center" style="display:none">
            <img src="[{$dir_images}]axialis/user-interface/loading.svg" class="animation-rotate mr10" /><strong>[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]</strong>
        </div>

        <div style="margin-top: 32px">
            <h1>[{isys type="lang" ident="LC__USER_SETTINGS__TFA__VERIFY_HEADER"}]</h1>
        </div>

        <div style="margin-top: 24px">
            <label class="display-block text-bold mb5" for="code">[{isys type="lang" ident="LC__USER_SETTINGS__TFA__VERIFY_AUTH_CODE_LABEL"}]</label>
            <input class="input input-block"
                   type="text"
                   name="code"
                   id="code"
                   value=""
                   autocomplete="off"
                   placeholder="[{isys type="lang" ident="LC__USER_SETTINGS__TFA__VERIFY_AUTH_CODE_PLACEHOLDER"}]"
                   autofocus="autofocus"
            />
        </div>
        <div class="box-red mt10 mb10 p10 hide" id="error-message-container">
            [{isys type="lang" ident="LC__USER_SETTINGS__TFA__VERIFY_AUTH_CODE_ERROR"}]
        </div>

        <div class="display-flex" style="margin-top: 32px; margin-bottom: 42px">
            <button type="button" id="cancel" class="mr-auto btn">
                <img src="[{$dir_images}]axialis/user-interface/arrow-left.svg" alt=""><span>[{isys type="lang" ident="LC__USER_SETTINGS__TFA__CANCEL"}]</span>
            </button>

            <button type="button" id="verify" class="ml-auto btn">
                <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt=""><span>[{isys type="lang" ident="LC__USER_SETTINGS__TFA__VERIFY"}]</span>
            </button>
        </div>

        <div class="display-flex justify-content-evenly align-items-center">
            <a href="https://www.i-doit.com/en/imprint/" class="text-underline" target="_blank">Imprint / Legal</a>
            <a href="https://www.i-doit.com/en/privacy-policy/" class="text-underline" target="_blank">Privacy Policy</a>
            <a href="https://www.i-doit.com" class="text-underline" target="_blank">i-doit.com - &copy; synetics gmbh</a>
        </div>
    </div>

    <div class="login-testimonial">
        <h1>[{$loginTestimonial}]</h1>
        <h2>Turn a world of data into<br />a galaxy of knowledge.</h2>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        const $errorMessageContainer = $('error-message-container');
        const $verifyButton = $('verify');

        $('cancel').on('click', () => window.location.href = '?logout=1');

        $verifyButton.on('click', function (e) {
            e.preventDefault();
            $errorMessageContainer.addClassName('hide');

            $verifyButton.down('img')
                .addClassName('animation-rotate')
                .writeAttribute('src', '[{$dir_images}]axialis/user-interface/loading.svg');

            // The 'idoit.Router' is not available in this context.
            new Ajax.Request('[{isys_application::instance()->container->get('route_generator')->generate('tfa.verify')}]', {
                method:     "post",
                parameters: {
                    code: $F('code')
                },
                onComplete: function (xhr) {
                    $verifyButton.down('img')
                        .removeClassName('animation-rotate')
                        .writeAttribute('src', '[{$dir_images}]axialis/basic/symbol-ok.svg');

                    if (!xhr.hasOwnProperty('responseJSON')) {
                        $errorMessageContainer.removeClassName('hide');
                        return;
                    }

                    const json = xhr.responseJSON;

                    if (json.success) {
                        // Using 'window.location.reload();' might result in a "re-submit postdata" notification from the browser.
                        window.location = window.location.href;
                        return;
                    }

                    $errorMessageContainer
                        .update(json.message)
                        .removeClassName('hide');
                }
            });
        });

        $('body').setAttribute('class', 'bg-light-blue');

        $('isys_form').on('submit', (e) => {
            e.preventDefault();
            $verifyButton.simulate('click')
        })
    })();
</script>
