<?php

global $g_comp_database;

// @see ID-10448 This migration will create missing rear segment template slots.

// Set migrationId
$migrationIdentifier = 'create-rear-rack-segments';

// Check whether migration was executed before
if ($this->is_migration_done($migrationIdentifier)) {
    $g_migration_log[] = '<span class="bold">Rear segments have already been created</span>';
} else {
    $g_migration_log[] = '<span class="bold">Create rear segments to segmentation templates...</span>';

    $dao = new \isys_cmdb_dao($g_comp_database);
    $sql = "SELECT *
        FROM isys_cats_chassis_view_list
        INNER JOIN isys_obj ON isys_obj__id = isys_cats_chassis_view_list__isys_obj__id
        WHERE isys_obj__const IN ('C__OBJ__RACK_SEGMENT__2SLOT', 'C__OBJ__RACK_SEGMENT__4SLOT', 'C__OBJ__RACK_SEGMENT__8SLOT');";

    $result = $dao->retrieve($sql);

    while ($row = $result->get_row()) {
        $objectId = (int)$row['isys_obj__id'];

        if ($row['isys_cats_chassis_view_list__rear_width'] >= 1 || $row['isys_cats_chassis_view_list__rear_height'] >= 1) {
            $g_migration_log[] = '<span>It seems like the rack segment template "' . $row['isys_obj__title'] . '" (#' . $objectId . ') was already updated - the migration will be skipped for this object.</span>';

            continue;
        }

        $g_migration_log[] = '<span>Update the rack segment template "' . $row['isys_obj__title'] . '" (#' . $objectId . ').</span>';

        $chassisViewId = (int)$row['isys_cats_chassis_view_list__id'];

        $query = "UPDATE isys_cats_chassis_view_list SET 
            isys_cats_chassis_view_list__rear_width = 4, 
            isys_cats_chassis_view_list__rear_height = 2 
            WHERE isys_cats_chassis_view_list__id = {$chassisViewId} 
            LIMIT 1;";

        $dao->update($query);
        $dao->apply_update();

        if ($row['isys_obj__const'] === 'C__OBJ__RACK_SEGMENT__2SLOT') {
            $slots = [
                ['xFrom' => 0, 'xTo' => 1, 'yFrom' => 0, 'yTo' => 1],
                ['xFrom' => 2, 'xTo' => 3, 'yFrom' => 0, 'yTo' => 1],
            ];
        } elseif ($row['isys_obj__const'] === 'C__OBJ__RACK_SEGMENT__4SLOT') {
            $slots = [
                ['xFrom' => 0, 'xTo' => 0, 'yFrom' => 0, 'yTo' => 1],
                ['xFrom' => 1, 'xTo' => 1, 'yFrom' => 0, 'yTo' => 1],
                ['xFrom' => 2, 'xTo' => 2, 'yFrom' => 0, 'yTo' => 1],
                ['xFrom' => 3, 'xTo' => 3, 'yFrom' => 0, 'yTo' => 1],
            ];
        } elseif ($row['isys_obj__const'] === 'C__OBJ__RACK_SEGMENT__8SLOT') {
            $slots = [
                ['xFrom' => 0, 'xTo' => 0, 'yFrom' => 0, 'yTo' => 0],
                ['xFrom' => 1, 'xTo' => 1, 'yFrom' => 0, 'yTo' => 0],
                ['xFrom' => 2, 'xTo' => 2, 'yFrom' => 0, 'yTo' => 0],
                ['xFrom' => 3, 'xTo' => 3, 'yFrom' => 0, 'yTo' => 0],
                ['xFrom' => 0, 'xTo' => 0, 'yFrom' => 1, 'yTo' => 1],
                ['xFrom' => 1, 'xTo' => 1, 'yFrom' => 1, 'yTo' => 1],
                ['xFrom' => 2, 'xTo' => 2, 'yFrom' => 1, 'yTo' => 1],
                ['xFrom' => 3, 'xTo' => 3, 'yFrom' => 1, 'yTo' => 1],
            ];
        }

        if (!isset($slots) || !is_array($slots)) {
            continue;
        }

        $g_migration_log[] = '<span class="indent">Create ' . count($slots) . ' rear slots.</span>';

        // This value relates to 'C__INSERTION__REAR'.
        $rearInsertion = 0;

        foreach ($slots as $i => $slot) {
            $num = $i + 1;

            $sql = "INSERT INTO isys_cats_chassis_slot_list SET
                isys_cats_chassis_slot_list__isys_obj__id = {$objectId},
                isys_cats_chassis_slot_list__title = 'Slot{$num}',
                isys_cats_chassis_slot_list__insertion = {$rearInsertion},
                isys_cats_chassis_slot_list__x_from = {$slot['xFrom']},
                isys_cats_chassis_slot_list__x_to = {$slot['xTo']},
                isys_cats_chassis_slot_list__y_from = {$slot['yFrom']},
                isys_cats_chassis_slot_list__y_to = {$slot['yTo']},
                isys_cats_chassis_slot_list__status = 2;";

            $dao->update($sql);
            $dao->apply_update();
        }
    }

    $g_migration_log[] = '<span class="bold">Migration finished!</span>';

    $this->migration_done($migrationIdentifier);
}
