<?php

namespace idoit\Module\JDisc\Graphql\Mutation\Authentication;

use GraphQL\Mutation;
use GraphQL\Query;
use idoit\Module\JDisc\Graphql\AbstractGraphql;
use idoit\Module\JDisc\Graphql\ParameterBagInterface;
use idoit\Module\JDisc\Graphql\ResponseInterface;
use idoit\Module\JDisc\Graphql\Type\AbstractType;
use idoit\Module\JDisc\Graphql\Type\StringType;

class Logout extends AbstractGraphql implements ParameterBagInterface
{
    /**
     * @var StringType
     */
    private StringType $accessToken;

    /**
     * @param StringType $accessToken
     *
     * @return void
     */
    protected function setAccessToken(StringType $accessToken): void
    {
        $this->accessToken = $accessToken;
    }

    /**
     * @return array|AbstractType[]
     */
    public function getParameters(): array
    {
        return [
            $this->accessToken
        ];
    }

    /**
     * @return array
     */
    public function getSelections(): array
    {
        return [];
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        $query = (new Mutation('authentication'))
            ->setVariables($this->buildVariables())
            ->setSelectionSet(
                [
                    (new Query('logout'))
                        ->setArguments($this->buildArguments())
                ]
            );

        return $query;
    }
}