<?php

namespace idoit\Module\License\Event\Subscriber\Admin;

use idoit\Module\License\Event\Tenant\TenantActivatedEvent;
use idoit\Module\License\Event\Tenant\TenantAddedEvent;
use idoit\Module\License\Event\Tenant\TenantBeforeAddedEvent;
use idoit\Module\License\Event\Tenant\TenantDeactivatedEvent;
use idoit\Module\License\Event\Tenant\TenantDeletedEvent;
use idoit\Module\License\Event\Tenant\TenantUpdatedEvent;
use idoit\Module\License\LicenseService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TenantSubscriber implements EventSubscriberInterface
{
    /**
     * @var LicenseService
     */
    private $licenseService;

    /**
     * LicenseSubscriber constructor.
     *
     * @param LicenseService $licenseService
     */
    public function __construct(LicenseService $licenseService)
    {
        $this->licenseService = $licenseService;
    }

    /**
     * Returns an array of event names this subscriber wants to listen to.
     *
     * The array keys are event names and the value can be:
     *
     *  * The method name to call (priority defaults to 0)
     *  * An array composed of the method name to call and the priority
     *  * An array of arrays composed of the method names to call and respective
     *    priorities, or 0 if unset
     *
     * For instance:
     *
     *  * array('eventName' => 'methodName')
     *  * array('eventName' => array('methodName', $priority))
     *  * array('eventName' => array(array('methodName1', $priority), array('methodName2')))
     *
     * @return array The event names to listen to
     */
    public static function getSubscribedEvents()
    {
        return [
            TenantDeactivatedEvent::NAME => 'updateObjectDivisionOnTenantDeactivate',
            TenantActivatedEvent::NAME => 'updateObjectDivisionOnTenantActivate',
            TenantDeletedEvent::NAME => 'updateObjectDivisionOnTenantDelete',
            TenantUpdatedEvent::NAME => 'updateObjectDivisionOnTenantUpdate',
            TenantAddedEvent::NAME => 'updateObjectDivisionOnTenantAdd'
        ];
    }

    public function updateObjectDivisionOnTenantDeactivate(TenantDeactivatedEvent $event)
    {
        $this->licenseService->updateObjectDivision();
    }

    public function updateObjectDivisionOnTenantActivate(TenantActivatedEvent $event)
    {
        $this->licenseService->updateObjectDivision();
    }

    public function updateObjectDivisionOnTenantUpdate(TenantUpdatedEvent $event)
    {
        $this->licenseService->updateObjectDivision();
    }

    public function updateObjectDivisionOnTenantAdd(TenantAddedEvent $event)
    {
        $this->licenseService->updateObjectDivision();
    }

    public function updateObjectDivisionOnTenantDelete(TenantDeletedEvent $event)
    {
        $this->licenseService->updateObjectDivision();
    }
}
