<?php

declare (strict_types=1);
namespace Axtiva\FlexibleGraphql\Example\GraphQL\Resolver\Transaction;

use GraphQL\Type\Definition\ResolveInfo;
use Axtiva\FlexibleGraphql\Resolver\ResolverInterface;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\TransactionType;
use Axtiva\FlexibleGraphql\Example\GraphQL\Model\TransactionStatusEnum;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * This is resolver for Transaction.status
 */
final class StatusResolver implements ResolverInterface
{
    /**
     * @param TransactionType $rootValue
     * @param $args
     * @param $context
     * @param ResolveInfo $info
     * @return TransactionStatusEnum
     */
    public function __invoke($rootValue, $args, $context, ResolveInfo $info)
    {
        $value = $rootValue->idStatus;
        $enum = null;
        if ($value === 0) {
            $enum = TransactionStatusEnum::NEW;
        } elseif ($value === 1) {
            $enum = TransactionStatusEnum::SUCCESS;
        } elseif ($value === 2) {
            $enum = TransactionStatusEnum::FAIL;
        }

        return new TransactionStatusEnum($enum);
    }
}