<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Component\Upload\UploadType;
use idoit\Module\JDisc\Upload\JDiscProfiles;
use idoit\Psr4AutoloaderClass;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\Routing\Loader\PhpFileLoader;

Autoloader::appendClassmap(include(__DIR__ . '/classmap.php'));

isys_register::factory('additional-dialog-admin-tables')
    ->set('isys_jdisc_status_list');

Psr4AutoloaderClass::factory()
    ->addNamespace('idoit\Module\JDisc', __DIR__ . '/src/');

$jdiscModule = new isys_module_jdisc();

isys_application::instance()->container->get('signals')
    ->connect('mod.settings.extendTree.data-import', [$jdiscModule, 'extendDataImportTree'])
    ->connect('mod.cmdb.objectDeleted', [$jdiscModule, 'clearMapping'])
    ->connect('mod.cmdb.afterObjectTypeSave', [$jdiscModule, 'slot_after_obj_type_save'])
    ->connect('mod.cmdb.viewProcessed', [$jdiscModule, 'slot_view_proceessed']);

// Add report view.
isys_register::factory('additional-report-views')
    ->set(__DIR__ . '/reportview/isys_report_view_jdisc_availability.class.php');

isys_application::instance()->container->get('upload')
    ->registerUploadType('jdisc.profiles-import', (new UploadType())
        ->setUploadDirectory('/temp/')
        ->setValidExtensions(['json'])
        ->setSizeLimit(16777216) // 16 MB
        ->setCallbackAfterUpload([JDiscProfiles::class, 'processUpload']));

// add new JDisc tenant archive settings
isys_application::instance()->container->get('settingsTenant')->extend([
    'LC__MODULE__JDISC' => [
        'jdisc.threshold' => [
            'title'       => 'LC__SETTINGS__JDISC__THRESHOLD',
            'type'        => 'int',
            'placeholder' => 30,
            'default'     => 0,
            'description' => 'LC__SETTINGS__JDISC__THRESHOLD__DESCRIPTION'
        ],
        'jdisc.threshold_type' => [
            'title'   => 'LC__SETTINGS__JDISC__THRESHOLD_TYPE',
            'type'    => 'select',
            'default' => 'LC__UNIVERSAL__DAYS',
            'options' => [
                'days'   => 'LC__UNIVERSAL__DAYS',
                'weeks'  => 'LC__UNIVERSAL__WEEKS',
                'months' => 'LC__UNIVERSAL__MONTHS'
            ],
        ],
    ]
]);

$session = isys_application::instance()->container->get('session');
if ($session->is_logged_in()) {
    // Add JDisc relevant routes.
    isys_application::instance()->container->get('routes')
        ->addCollection((new PhpFileLoader(new FileLocator(__DIR__)))->load('config/routes.php'));
}
