<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type LicenseInfo
 * The license information for the product */
final class LicenseInfoType implements AutoGenerationInterface
{
    /**
     * Gets the license expiration date. Null for perpetual licenses.
     */
    public $gqlLicenseEnd = null;
    /**
     * Gets the license start date. The license is not valid before that date.
     */
    public $gqlLicenseStart = null;
    /**
     * Gets the number of used credits.
     */
    public $calcUsedCredits = null;
    /**
     * Gets the list of license sections for the add-ons.
     * @var null|iterable
     */
    public ?iterable $addOns = null;
    /**
     * Gets the credit allocation for the four tiers.
     */
    public ?DeviceCreditAllocationType $creditAllocation = null;
    /**
     * Gets the current licensed device counts per tier.
     */
    public ?DeviceCreditCountType $creditCount = null;
    /**
     * Gets the maximal number of licensed credits.
     */
    public $creditLimit = null;
    /**
     * Gets the maximal number of licensed devices.
     */
    public ?int $deviceLimit = null;
    /**
     * Gets the maximal number of licensed credits.
     */
    public ?ProductEditionEnum $edition = null;
    /**
     * Gets the list of installed add-ons.
     * @var null|iterable|AddOnProductEnum[]
     */
    public ?iterable $installedAddOns = null;
    /**
     * Gets the licensed sections (each product has its own section)
     * @var null|iterable
     */
    public ?iterable $licenseSections = null;
    /**
     * Gets the list of licensed add-ons.
     * @var null|iterable|AddOnProductEnum[]
     */
    public ?iterable $licensedAddOns = null;
    /**
     * Gets the license status.
     */
    public ?LicenseStatusEnum $status = null;
    /**
     * Gets the number of used credits.
     */
    public $usedCredits = null;
    /**
     * Gets the list of devices used for the license (in case of device count based license).
     */
    public ?int $usedDevices = null;
}