<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type SnmpV3Account
 * An account object for the SNMPv3 protocol containing login, password, auth type, priv type, priv password and comment. The password is for security reasons write-only. */
final class SnmpV3AccountType implements AutoGenerationInterface
{
    /**
     * The account's authentication protocol.
     */
    public ?SnmpV3AuthProtocolEnum $authProtocol = null;
    /**
     * The account's comment string.
     */
    public ?string $comment = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The account's login name.
     */
    public ?string $login = null;
    /**
     * The account's password. IMPORTANT: This field is never populated when being read from the database. This field is only used when setting passwords from the UI
     */
    public ?string $password = null;
    /**
     * The account's encryption password. IMPORTANT: This field is never populated when being read from the database. This field is only used when setting passwords from the UI
     */
    public ?string $privPassword = null;
    /**
     * The account's privacy/encryption protocol.
     */
    public ?SnmpV3PrivProtocolEnum $privProtocol = null;
}