[{isys_group name="tom.popup.profilesImport"}]
    <div id="custom-profiles-import">
        <div class="popup-header-ng">
            <h1>[{isys type="lang" ident="LC__PROFILES_IMPORT__UPLOAD"}]</h1>
            <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
                <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
            </button>
        </div>
        <div class="popup-content p10">
            <table class="contentTable">
                <tr>
                    <td class="key">[{isys type="f_label" name="C__JDISC_PROFILES__MERGE_PROFILES" ident="LC__PROFILES_IMPORT__MERGE_PROFILES"}]</td>
                    <td class="value">[{isys type="f_dialog" name="C__JDISC_PROFILES__MERGE_PROFILES"}]</td>
                </tr>
                <tr>
                    <td class="key">[{isys type="lang" ident="LC__PROFILES_IMPORT__UPLOAD"}]</td>
                    <td class="value pl20">[{isys type="f_file_ajax" name="C__JDISC_PROFILES__UPLOAD" uploadType="jdisc.profiles-import"}]</td>
                </tr>
            </table>

            <div id="custom-profiles-import-result" class="box box-blue hide"></div>
        </div>
        <div class="popup-footer-ng">
            <button type="button" class="btn popup-closer">
                <span>[{isys type="lang" ident="LC__VISUALIZATION_PROFILES__CLOSE_POPUP"}]</span>
            </button>
        </div>
    </div>

    <style>
        #custom-translation-import .qq-upload-list {
            width: 300px;
        }
    </style>

    <script>
        (function () {
            'use strict';

            const $popup = $('custom-profiles-import');
            const $importResult = $('custom-profiles-import-result');
            let closeAndReload = false;

            $popup.on('click', '.popup-closer', function () {
                if (closeAndReload) {
                    document.location.href = '[{$redirectUrl}]'
                } else {
                    popup_close();
                }
            });

            $('body').fire('update:tooltips');

            idoit.callbackManager.registerCallback('smarty-ajax-file-upload-before-upload', function(uploader) {
                uploader.setParams({
                    type: 'jdisc.profiles-import',
                    merge: $F('C__JDISC_PROFILES__MERGE_PROFILES')
                });
            });

            idoit.callbackManager.registerCallback('smarty-ajax-file-upload', function (result) {
                let index;
                const $resultList = new Element('ul', { className: 'list-style-none m0 p0' });

                for (index in result.callbackResult) {
                    if (!result.callbackResult.hasOwnProperty(index)) {
                        continue;
                    }

                    $resultList.insert(new Element('li', { className: 'p5' }).update(result.callbackResult[index]));
                }

                $importResult.update($resultList).removeClassName('hide');
                closeAndReload = true;
            });
        })();
    </script>
    [{/isys_group}]
