<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type InstalledServiceInput
 * A service installed on an operating system. * @property null|string $binaryName = null The binary name for this service
 * @property null|string $displayName = null The display name for this service
 * @property null|ServiceFailureActionEnum $failureAction = null The service installation path
 * @property null|string $installationPath = null The service installation path
 * @property null|string $parameters = null The parameters that this service is called with
 * @property null|ServiceStartupModeEnum $startupMode = null The service installation path
 * @property null|ServiceStatusEnum $status = null The service installation path
 * @property null|OperatingSystemInputInputType $operatingSystem = null The operating system that this service is installed on
 * @property null|ServiceInputInputType $service = null The associated service
 */
final class InstalledServiceInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'failureAction') {
            return new ServiceFailureActionEnum($value);
        }

        if ($name === 'startupMode') {
            return new ServiceStartupModeEnum($value);
        }

        if ($name === 'status') {
            return new ServiceStatusEnum($value);
        }

        if ($name === 'operatingSystem') {
            return new OperatingSystemInputInputType($value);
        }

        if ($name === 'service') {
            return new ServiceInputInputType($value);
        }

        return $value;
    }
}