<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type OperatingSystem
 * The operating system for a specific device. */
final class OperatingSystemType implements AutoGenerationInterface
{
    /**
     * The list of all application instances (e.g. database instances, web server instances, ...).
     * @var null|iterable
     */
    public ?iterable $applicationInstances = null;
    /**
     * The operating system compile time
     */
    public $compileTime = null;
    /**
     * The operating system description
     */
    public ?string $description = null;
    /**
     * The device that this operating system is installed on.
     */
    public ?DeviceType $device = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The operating system's install date
     */
    public $installDate = null;
    /**
     * The list of installed applications.
     * @var null|iterable
     */
    public ?iterable $installedApplications = null;
    /**
     * The list of installed certificates.
     * @var null|iterable
     */
    public ?iterable $installedCertificates = null;
    /**
     * The list of installed patches.
     * @var null|iterable
     */
    public ?iterable $installedPatches = null;
    /**
     * The list of installed services.
     * @var null|iterable
     */
    public ?iterable $installedServices = null;
    /**
     * The kernel version
     */
    public ?string $kernelVersion = null;
    /**
     * The operating system's last update time
     */
    public $lastUpdateTime = null;
    /**
     * The operating system's license comment
     */
    public ?string $licenseComment = null;
    /**
     * The operating system's license expiration date
     */
    public $licenseExpirationDate = null;
    /**
     * The operating system's license status
     */
    public ?SoftwareLicenseStatusEnum $licenseStatus = null;
    /**
     * The license type
     */
    public ?LicenseTypeEnum $licenseType = null;
    /**
     * Gets the list of users which belong to this operating system.
     * @var null|iterable
     */
    public ?iterable $localUsers = null;
    /**
     * The locale that is used for this operating system
     */
    public ?string $locale = null;
    /**
     * The locale code that is used for this operating system
     */
    public ?int $localeCode = null;
    /**
     * Gets the list of logged-on users to this operating system
     * @var null|iterable
     */
    public ?iterable $loggedOnUsers = null;
    /**
     * Gets the list of history logged-on users to this operating system
     * @var null|iterable
     */
    public ?iterable $loggedOnUsersHistory = null;
    /**
     * The operating system's manufacturer
     */
    public ?string $manufacturer = null;
    /**
     * The list of all mapped printers.
     * @var null|iterable
     */
    public ?iterable $mappedPrinters = null;
    /**
     * The operating system family (e.g. Windows, Linux, HP-UX, ...)
     */
    public ?string $osFamily = null;
    /**
     * The operating system version (e.g. Windows 10, Windows 2008 Server, ...)
     */
    public ?string $osVersion = null;
    /**
     * The patch level (e.g. Service Pack 3)
     */
    public ?string $owner = null;
    /**
     * The patch level (e.g. Service Pack 3)
     */
    public ?string $patchLevel = null;
    /**
     * The list of pending installations.
     * @var null|iterable
     */
    public ?iterable $pendingUpdates = null;
    /**
     * The list of all processes running on this operating system.
     * @var null|iterable
     */
    public ?iterable $processes = null;
    /**
     * The operting system product key
     */
    public ?string $productKey = null;
    /**
     * The raw version as it gets delivered by the operating system
     */
    public ?string $rawVersion = null;
    /**
     * The device's system type (e.g. x64, x86, arm, ...)
     */
    public ?string $systemType = null;
    /**
     * The operating system's unique id
     */
    public ?string $uniqueId = null;
    /**
     * The list of all application instances (e.g. database instances, web server instances, ...).
     * @var null|iterable
     */
    public ?iterable $applicationInstancesByType = null;
}